/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.util.CheckReturnValue;
import org.w3c.dom.Node;
import org.xmlunit.assertj.AssertionsAdapter;
import org.xmlunit.assertj.NodeUtils;
import org.xmlunit.assertj.XPathEngineFactory;
import org.xmlunit.assertj.XmlAssert;
import org.xmlunit.assertj.XmlAssertConfig;
import org.xmlunit.assertj.error.ShouldBeConvertible;
import org.xmlunit.xpath.XPathEngine;

public class ValueAssert
extends AbstractCharSequenceAssert<ValueAssert, String> {
    private ValueAssert(String value) {
        super(value, ValueAssert.class);
    }

    static ValueAssert create(Object xmlSource, String xPath, XmlAssertConfig config) {
        AssertionsAdapter.assertThat(xPath, (AssertionInfo)config.info).isNotBlank();
        XPathEngine engine = XPathEngineFactory.create(config);
        Node root = NodeUtils.parseSource(xmlSource, config);
        String value = engine.evaluate(xPath, root);
        ValueAssert valueAssert = AssertionsAdapter.withAssertInfo(new ValueAssert(value), config.info);
        if (!valueAssert.info.hasDescription()) {
            valueAssert.info.description("XPath \"%s\" evaluated to value", xPath);
        }
        return valueAssert;
    }

    public AbstractIntegerAssert<?> asInt() {
        this.isNotNull();
        int value = 0;
        try {
            value = Integer.parseInt((String)this.actual);
        }
        catch (NumberFormatException e) {
            this.throwAssertionError(ShouldBeConvertible.shouldBeConvertible((String)this.actual, "int"));
        }
        return AssertionsAdapter.assertThat(value, (AssertionInfo)this.info);
    }

    public AbstractDoubleAssert<?> asDouble() {
        this.isNotNull();
        double value = 0.0;
        try {
            value = Double.parseDouble((String)this.actual);
        }
        catch (NumberFormatException e) {
            this.throwAssertionError(ShouldBeConvertible.shouldBeConvertible((String)this.actual, "double"));
        }
        return AssertionsAdapter.assertThat(value, (AssertionInfo)this.info);
    }

    public AbstractBooleanAssert<?> asBoolean() {
        this.isNotNull();
        boolean value = false;
        switch (((String)this.actual).toLowerCase()) {
            case "true": {
                value = true;
                break;
            }
            case "false": {
                value = false;
                break;
            }
            default: {
                this.throwAssertionError(ShouldBeConvertible.shouldBeConvertible((String)this.actual, "boolean"));
            }
        }
        return AssertionsAdapter.assertThat(value, (AssertionInfo)this.info);
    }

    public XmlAssert asXml() {
        this.isNotNull();
        return this.asXml(null);
    }

    public XmlAssert asXml(String wrapNodeName) {
        this.isNotNull();
        String xml = wrapNodeName == null || wrapNodeName.isEmpty() ? (String)this.actual : String.format("<%s>%s</%s>", wrapNodeName, this.actual, wrapNodeName);
        return AssertionsAdapter.withAssertInfo(XmlAssert.assertThat(xml), this.info);
    }

    public ValueAssert isEqualTo(int expected) {
        this.asInt().isEqualTo(expected);
        return this;
    }

    public ValueAssert isEqualTo(double expected) {
        this.asDouble().isEqualTo(expected);
        return this;
    }

    public ValueAssert isEqualTo(boolean expected) {
        this.asBoolean().isEqualTo(expected);
        return this;
    }

    @Override
    @CheckReturnValue
    public ValueAssert describedAs(String description, Object ... args) {
        this.getWritableAssertionInfo().description(description, args);
        return (ValueAssert)this.myself;
    }
}

