/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.transform.TransformerException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.preflight.utils.ByteArrayDataSource;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.ArrayProperty;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.ZUGFeRD.CustomXMLProvider;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IExporter;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDExporter;
import org.mustangproject.ZUGFeRD.PDFAConformanceLevel;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.XMPSchemaPDFAExtensions;
import org.mustangproject.ZUGFeRD.XMPSchemaZugferd;
import org.mustangproject.ZUGFeRD.XRExporter;
import org.mustangproject.ZUGFeRD.ZUGFeRD1PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDExportException;

public class ZUGFeRDExporterFromA3
extends XRExporter
implements IZUGFeRDExporter,
IExporter,
Closeable {
    private boolean isFacturX = true;
    public static final int DefaultZUGFeRDVersion = 2;
    protected PDFAConformanceLevel conformanceLevel = PDFAConformanceLevel.UNICODE;
    protected ArrayList<FileAttachment> fileAttachments = new ArrayList();
    protected boolean overwrite = true;
    private boolean disableAutoClose;
    private boolean fileAttached = false;
    private Profile profile = null;
    protected boolean documentPrepared = false;
    protected PDMetadata metadata = null;
    protected XMPMetadata xmp = null;
    protected String producer = "mustangproject";
    protected String creator = "mustangproject";
    protected String creatorTool = "mustangproject";
    @Deprecated
    protected String author;
    @Deprecated
    protected String title;
    @Deprecated
    protected String subject;
    protected PDDocument doc;
    private HashMap<String, byte[]> additionalXMLs = new HashMap();
    protected int ZFVersion = 2;
    private boolean attachZUGFeRDHeaders = true;
    protected String XRechnungVersion = null;

    @Override
    public ZUGFeRDExporterFromA3 load(String pdfFilename) throws IOException {
        this.ensurePDFIsValid(new FileDataSource(pdfFilename));
        try (FileInputStream pdf = new FileInputStream(pdfFilename);){
            ZUGFeRDExporterFromA3 zUGFeRDExporterFromA3 = this.load(ZUGFeRDExporterFromA3.readAllBytes(pdf));
            return zUGFeRDExporterFromA3;
        }
    }

    @Override
    public IXMLProvider getProvider() {
        return this.xmlProvider;
    }

    public ZUGFeRDExporterFromA3 setProfile(Profile p) {
        this.profile = p;
        if (this.xmlProvider != null) {
            this.xmlProvider.setProfile(p);
        }
        return this;
    }

    public ZUGFeRDExporterFromA3 setProfile(String profilename) {
        this.profile = Profiles.getByName(profilename);
        if (this.xmlProvider != null) {
            this.xmlProvider.setProfile(this.profile);
        }
        return this;
    }

    public ZUGFeRDExporterFromA3 addAdditionalFile(String name, byte[] content) {
        this.fileAttachments.add(new FileAttachment(name, "text/xml", "Supplement", content).setDescription("ZUGFeRD extension/additional data"));
        return this;
    }

    @Override
    public String getNamespaceForVersion(int ver) {
        if (this.isFacturX) {
            return "urn:factur-x:pdfa:CrossIndustryDocument:invoice:1p0#";
        }
        if (ver == 1) {
            return "urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#";
        }
        if (ver == 2) {
            return "urn:zugferd:pdfa:CrossIndustryDocument:invoice:2p0#";
        }
        throw new IllegalArgumentException("Version not supported");
    }

    @Override
    public String getPrefixForVersion(int ver) {
        if (this.isFacturX) {
            return "fx";
        }
        return "zf";
    }

    public String getFilenameForVersion(int ver, Profile profile) {
        if (this.isFacturX) {
            return "factur-x.xml";
        }
        if (ver == 1) {
            return "ZUGFeRD-invoice.xml";
        }
        if (profile.getName().equals("XRECHNUNG")) {
            return "xrechnung.xml";
        }
        return "zugferd-invoice.xml";
    }

    public ZUGFeRDExporterFromA3 setFacturX() {
        this.isFacturX = true;
        return this;
    }

    public void setXRechnungSpecificVersion(String XRechnungVersion) {
        this.XRechnungVersion = XRechnungVersion;
    }

    @Override
    public IZUGFeRDExporter disableFacturX() {
        this.isFacturX = false;
        return this;
    }

    @Override
    public ZUGFeRDExporterFromA3 load(byte[] pdfBinary) throws IOException {
        this.ensurePDFIsValid(new ByteArrayDataSource(new ByteArrayInputStream(pdfBinary)));
        this.doc = PDDocument.load(pdfBinary);
        return this;
    }

    public void attachFile(FileAttachment file) {
        this.fileAttachments.add(file);
    }

    public void attachFile(String filename, byte[] data, String mimetype, String relation) {
        FileAttachment fa = new FileAttachment(filename, mimetype, relation, data);
        this.fileAttachments.add(fa);
    }

    @Override
    public void export(String ZUGFeRDfilename) throws IOException {
        if (!this.documentPrepared) {
            this.prepareDocument();
        }
        if (!this.fileAttached && this.attachZUGFeRDHeaders) {
            throw new IOException("File must be attached (usually with setTransaction) before perfoming this operation");
        }
        this.doc.save(ZUGFeRDfilename);
        if (!this.disableAutoClose) {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.doc != null) {
            this.doc.close();
        }
    }

    @Override
    public void export(OutputStream output) throws IOException {
        if (!this.documentPrepared) {
            this.prepareDocument();
        }
        if (!this.fileAttached && this.attachZUGFeRDHeaders) {
            throw new IOException("File must be attached (usually with setTransaction) before perfoming this operation");
        }
        this.doc.save(output);
        if (!this.disableAutoClose) {
            this.close();
        }
    }

    public void PDFAttachGenericFile(String filename, String relationship, String description, String subType, byte[] data) throws IOException {
        this.PDFAttachGenericFile(this.doc, filename, relationship, description, subType, data);
    }

    public void PDFAttachGenericFile(PDDocument doc, String filename, String relationship, String description, String subType, byte[] data) throws IOException {
        COSArray cosArray;
        this.fileAttached = true;
        PDComplexFileSpecification fs = new PDComplexFileSpecification();
        fs.setFile(filename);
        COSDictionary dict = fs.getCOSObject();
        dict.setName("AFRelationship", relationship);
        dict.setString("UF", filename);
        dict.setString("Desc", description);
        ByteArrayInputStream fakeFile = new ByteArrayInputStream(data);
        PDEmbeddedFile ef = new PDEmbeddedFile(doc, fakeFile);
        ef.setSubtype(subType);
        ef.setSize(data.length);
        ef.setCreationDate(new GregorianCalendar());
        ef.setModDate(GregorianCalendar.getInstance());
        fs.setEmbeddedFile(ef);
        dict = fs.getCOSObject();
        COSDictionary efDict = (COSDictionary)dict.getDictionaryObject(COSName.EF);
        COSBase lowerLevelFile = efDict.getItem(COSName.F);
        efDict.setItem(COSName.UF, lowerLevelFile);
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = names.getEmbeddedFiles();
        if (efTree == null) {
            efTree = new PDEmbeddedFilesNameTreeNode();
        }
        HashMap<String, PDComplexFileSpecification> namesMap = new HashMap<String, PDComplexFileSpecification>();
        Map oldNamesMap = efTree.getNames();
        if (oldNamesMap != null) {
            for (String key : oldNamesMap.keySet()) {
                namesMap.put(key, (PDComplexFileSpecification)oldNamesMap.get(key));
            }
        }
        namesMap.put(filename, fs);
        efTree.setNames(namesMap);
        names.setEmbeddedFiles(efTree);
        doc.getDocumentCatalog().setNames(names);
        COSBase AFEntry = doc.getDocumentCatalog().getCOSObject().getItem("AF");
        if (AFEntry == null) {
            cosArray = new COSArray();
            cosArray.add(fs);
            doc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
        } else if (AFEntry instanceof COSArray) {
            cosArray = (COSArray)AFEntry;
            cosArray.add(fs);
            doc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
        } else if (AFEntry instanceof COSObject && ((COSObject)AFEntry).getObject() instanceof COSArray) {
            cosArray = (COSArray)((COSObject)AFEntry).getObject();
            cosArray.add(fs);
        } else {
            throw new IOException("Unexpected object type for PDFDocument/Catalog/COSDictionary/Item(AF)");
        }
    }

    @Override
    public ZUGFeRDExporterFromA3 setXML(byte[] zugferdData) throws IOException {
        CustomXMLProvider cus = new CustomXMLProvider();
        cus.setXML(zugferdData);
        this.setXMLProvider(cus);
        this.prepare();
        return this;
    }

    @Override
    public ZUGFeRDExporterFromA3 load(InputStream pdfSource) throws IOException {
        return this.load(ZUGFeRDExporterFromA3.readAllBytes(pdfSource));
    }

    @Override
    public boolean ensurePDFIsValid(DataSource dataSource) throws IOException {
        return true;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IOUtils.copy(in, buffer);
        return buffer.toByteArray();
    }

    @Override
    public ZUGFeRDExporterFromA3 setConformanceLevel(PDFAConformanceLevel newLevel) {
        this.conformanceLevel = newLevel;
        return this;
    }

    @Override
    public ZUGFeRDExporterFromA3 setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public ZUGFeRDExporterFromA3 setCreatorTool(String creatorTool) {
        this.creatorTool = creatorTool;
        return this;
    }

    @Override
    public ZUGFeRDExporterFromA3 setProducer(String producer) {
        this.producer = producer;
        return this;
    }

    protected ZUGFeRDExporterFromA3 setAttachZUGFeRDHeaders(boolean attachHeaders) {
        this.attachZUGFeRDHeaders = attachHeaders;
        return this;
    }

    protected void addXMP(XMPMetadata metadata) {
        String metaDataVersion = null;
        if (this.XRechnungVersion != null && this.profile != null && this.profile.getName().equalsIgnoreCase(Profiles.getByName("XRECHNUNG").getName())) {
            metaDataVersion = this.XRechnungVersion;
        }
        if (this.attachZUGFeRDHeaders) {
            XMPSchemaZugferd zf = new XMPSchemaZugferd(metadata, this.ZFVersion, this.isFacturX, this.xmlProvider.getProfile(), this.getNamespaceForVersion(this.ZFVersion), this.getPrefixForVersion(this.ZFVersion), this.getFilenameForVersion(this.ZFVersion, this.xmlProvider.getProfile()), metaDataVersion);
            metadata.addSchema(zf);
        }
        XMPSchemaPDFAExtensions pdfaex = new XMPSchemaPDFAExtensions(this, metadata, this.ZFVersion, this.attachZUGFeRDHeaders);
        pdfaex.setZUGFeRDVersion(this.ZFVersion);
        metadata.addSchema(pdfaex);
    }

    private void removeCidSet(PDDocumentCatalog catalog, PDDocument doc) throws IOException {
        COSName cidSet = COSName.getPDFName("CIDSet");
        for (PDPage object : doc.getPages()) {
            if (!(object instanceof PDPage)) continue;
            PDPage page = object;
            PDResources res = page.getResources();
            for (COSName fontName : res.getFontNames()) {
                PDType0Font typedFont;
                PDFont pdFont = res.getFont(fontName);
                if (!(pdFont instanceof PDType0Font) || !((typedFont = (PDType0Font)pdFont).getDescendantFont() instanceof PDCIDFontType2)) continue;
                PDCIDFontType2 f = (PDCIDFontType2)typedFont.getDescendantFont();
                PDFontDescriptor fontDescriptor = pdFont.getFontDescriptor();
                fontDescriptor.getCOSObject().removeItem(cidSet);
            }
        }
    }

    protected void prepareDocument() throws IOException {
        PDDocumentCatalog cat = this.doc.getDocumentCatalog();
        this.metadata = new PDMetadata(this.doc);
        cat.setMetadata(this.metadata);
        this.removeCidSet(cat, this.doc);
        this.xmp = this.getXmpMetadata();
        this.writeAdobePDFSchema(this.xmp);
        this.writePDFAIdentificationSchema(this.xmp);
        this.writeDublinCoreSchema(this.xmp);
        this.writeXMLBasicSchema(this.xmp);
        this.writeDocumentInformation();
        this.addSRGBOutputIntend();
        this.setMarked();
        this.addStructureTreeRoot();
        this.addXMP(this.xmp);
        try {
            this.metadata.importXMPMetadata(this.serializeXmpMetadata(this.xmp));
        }
        catch (TransformerException e) {
            throw new ZUGFeRDExportException("Could not export XmpMetadata", e);
        }
        this.documentPrepared = true;
    }

    @Override
    public IExporter setTransaction(IExportableTransaction trans) throws IOException {
        this.trans = trans;
        return this.prepare();
    }

    public IExporter prepare() throws IOException {
        this.prepareDocument();
        this.xmlProvider.generateXML(this.trans);
        String filename = this.getFilenameForVersion(this.ZFVersion, this.xmlProvider.getProfile());
        String relationship = "Alternative";
        if (this.profile != null && this.ZFVersion >= 2 && (this.profile.getName().equalsIgnoreCase(Profiles.getByName("MINIMUM").getName()) || this.profile.getName().equalsIgnoreCase(Profiles.getByName("BASICWL").getName()))) {
            relationship = "Data";
        }
        this.PDFAttachGenericFile(this.doc, filename, relationship, "Invoice metadata conforming to ZUGFeRD standard (http://www.ferd-net.de/front_content.php?idcat=231&lang=4)", "text/xml", this.xmlProvider.getXML());
        for (FileAttachment attachment : this.fileAttachments) {
            this.PDFAttachGenericFile(this.doc, attachment.getFilename(), attachment.getRelation(), attachment.getDescription(), attachment.getMimetype(), attachment.getData());
        }
        return this;
    }

    protected XMPMetadata getXmpMetadata() throws IOException {
        PDMetadata meta = this.doc.getDocumentCatalog().getMetadata();
        if (meta != null && meta.getLength() > 0) {
            try {
                DomXmpParser xmpParser = new DomXmpParser();
                return xmpParser.parse(meta.toByteArray());
            }
            catch (XmpParsingException e) {
                throw new IOException(e);
            }
        }
        return XMPMetadata.createXMPMetadata();
    }

    protected byte[] serializeXmpMetadata(XMPMetadata xmpMetadata) throws TransformerException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new XmpSerializer().serialize(xmpMetadata, buffer, true);
        return buffer.toByteArray();
    }

    protected void writeAdobePDFSchema(XMPMetadata xmp) {
        AdobePDFSchema pdf = this.getAdobePDFSchema(xmp);
        if (this.overwrite || this.isEmpty(pdf.getProducer())) {
            pdf.setProducer(this.producer);
        }
    }

    protected AdobePDFSchema getAdobePDFSchema(XMPMetadata xmp) {
        AdobePDFSchema pdf = xmp.getAdobePDFSchema();
        if (pdf != null) {
            if (this.overwrite) {
                xmp.removeSchema(pdf);
            } else {
                return pdf;
            }
        }
        return xmp.createAndAddAdobePDFSchema();
    }

    protected void writePDFAIdentificationSchema(XMPMetadata xmp) {
        PDFAIdentificationSchema pdfaid = this.getPDFAIdentificationSchema(xmp);
        if (this.overwrite || this.isEmpty(pdfaid.getConformance())) {
            try {
                pdfaid.setConformance(this.conformanceLevel.getLetter());
            }
            catch (BadFieldValueException ex) {
                throw new Error(ex);
            }
        }
        pdfaid.setPart(3);
    }

    protected PDFAIdentificationSchema getPDFAIdentificationSchema(XMPMetadata xmp) {
        PDFAIdentificationSchema pdfaid = xmp.getPDFIdentificationSchema();
        if (pdfaid != null) {
            if (this.overwrite) {
                xmp.removeSchema(pdfaid);
            } else {
                return pdfaid;
            }
        }
        return xmp.createAndAddPFAIdentificationSchema();
    }

    protected void writeDublinCoreSchema(XMPMetadata xmp) {
        ArrayProperty titleProperty;
        DublinCoreSchema dc = this.getDublinCoreSchema(xmp);
        if (dc.getFormat() == null) {
            dc.setFormat("application/pdf");
        }
        if ((this.overwrite || dc.getCreators() == null || dc.getCreators().isEmpty()) && this.creator != null) {
            dc.addCreator(this.creator);
        }
        if ((this.overwrite || dc.getDates() == null || dc.getDates().isEmpty()) && this.creator != null) {
            dc.addDate(Calendar.getInstance());
        }
        if ((titleProperty = dc.getTitleProperty()) != null) {
            if (this.overwrite && !this.isEmpty(this.title)) {
                dc.removeProperty(titleProperty);
                dc.setTitle(this.title);
            } else if (titleProperty.getElementsAsString().stream().anyMatch("Untitled"::equalsIgnoreCase)) {
                dc.removeProperty(titleProperty);
            }
        } else if (!this.isEmpty(this.title)) {
            dc.setTitle(this.title);
        }
    }

    protected DublinCoreSchema getDublinCoreSchema(XMPMetadata xmp) {
        DublinCoreSchema dc = xmp.getDublinCoreSchema();
        if (dc != null) {
            if (this.overwrite) {
                xmp.removeSchema(dc);
            } else {
                return dc;
            }
        }
        return xmp.createAndAddDublinCoreSchema();
    }

    protected void writeXMLBasicSchema(XMPMetadata xmp) {
        XMPBasicSchema xsb = this.getXmpBasicSchema(xmp);
        if (this.overwrite || this.isEmpty(xsb.getCreatorTool()) || "UnknownApplication".equals(xsb.getCreatorTool())) {
            xsb.setCreatorTool(this.creatorTool);
        }
        if (this.overwrite || xsb.getCreateDate() == null) {
            xsb.setCreateDate(GregorianCalendar.getInstance());
        }
    }

    protected XMPBasicSchema getXmpBasicSchema(XMPMetadata xmp) {
        XMPBasicSchema xsb = xmp.getXMPBasicSchema();
        if (xsb != null) {
            if (this.overwrite) {
                xmp.removeSchema(xsb);
            } else {
                return xsb;
            }
        }
        return xmp.createAndAddXMPBasicSchema();
    }

    protected void writeDocumentInformation() {
        String fullProducer = this.producer + " (via mustangproject.org " + "2.6.2" + ")";
        PDDocumentInformation info = this.doc.getDocumentInformation();
        if (this.overwrite || info.getCreationDate() == null) {
            info.setCreationDate(Calendar.getInstance());
        }
        if (this.overwrite || info.getModificationDate() == null) {
            info.setModificationDate(Calendar.getInstance());
        }
        if (this.overwrite || this.isEmpty(info.getAuthor()) && !this.isEmpty(this.author)) {
            info.setAuthor(this.author);
        }
        if (this.overwrite || this.isEmpty(info.getProducer()) && !this.isEmpty(fullProducer)) {
            info.setProducer(fullProducer);
        }
        if (this.overwrite || this.isEmpty(info.getCreator()) && !this.isEmpty(this.creator)) {
            info.setCreator(this.creator);
        }
        if (this.overwrite || this.isEmpty(info.getTitle()) && !this.isEmpty(this.title)) {
            info.setTitle(this.title);
        }
        if (this.overwrite || this.isEmpty(info.getSubject()) && !this.isEmpty(this.subject)) {
            info.setSubject(this.subject);
        }
    }

    protected void addSRGBOutputIntend() throws IOException {
        if (!this.doc.getDocumentCatalog().getOutputIntents().isEmpty()) {
            return;
        }
        InputStream colorProfile = Thread.currentThread().getContextClassLoader().getResourceAsStream("sRGB.icc");
        if (colorProfile != null) {
            PDOutputIntent intent = new PDOutputIntent(this.doc, colorProfile);
            intent.setInfo("sRGB IEC61966-2.1");
            intent.setOutputCondition("sRGB IEC61966-2.1");
            intent.setOutputConditionIdentifier("sRGB IEC61966-2.1");
            intent.setRegistryName("http://www.color.org");
            this.doc.getDocumentCatalog().addOutputIntent(intent);
        }
    }

    protected void setMarked() {
        PDDocumentCatalog catalog = this.doc.getDocumentCatalog();
        if (catalog.getMarkInfo() == null) {
            catalog.setMarkInfo(new PDMarkInfo(this.doc.getPages().getCOSObject()));
        }
        catalog.getMarkInfo().setMarked(true);
    }

    protected void addStructureTreeRoot() {
        if (this.doc.getDocumentCatalog().getStructureTreeRoot() == null) {
            this.doc.getDocumentCatalog().setStructureTreeRoot(new PDStructureTreeRoot());
        }
    }

    public boolean isAutoCloseDisabled() {
        return this.disableAutoClose;
    }

    @Override
    public ZUGFeRDExporterFromA3 disableAutoClose(boolean disableAutoClose) {
        this.disableAutoClose = disableAutoClose;
        return this;
    }

    protected void setXMLProvider(IXMLProvider p) {
        this.xmlProvider = p;
        if (this.profile != null) {
            this.xmlProvider.setProfile(this.profile);
        }
    }

    public ZUGFeRDExporterFromA3 setZUGFeRDVersion(EStandard est, int version) {
        this.ZFVersion = version;
        if (version < 1 || version > 2) {
            throw new IllegalArgumentException("Version not supported");
        }
        int generation = version;
        if (est == EStandard.facturx && version == 1) {
            generation = 2;
        }
        if (generation == 1) {
            ZUGFeRD1PullProvider z1p = new ZUGFeRD1PullProvider();
            this.disableFacturX();
            this.setXMLProvider(z1p);
        } else if (generation == 2) {
            ZUGFeRD2PullProvider z2p = new ZUGFeRD2PullProvider();
            this.setXMLProvider(z2p);
        }
        return this;
    }

    @Override
    public ZUGFeRDExporterFromA3 setZUGFeRDVersion(int version) {
        this.ZFVersion = version;
        if (version == 1) {
            ZUGFeRD1PullProvider z1p = new ZUGFeRD1PullProvider();
            this.disableFacturX();
            this.setXMLProvider(z1p);
        } else if (version == 2) {
            ZUGFeRD2PullProvider z2p = new ZUGFeRD2PullProvider();
            this.setXMLProvider(z2p);
        } else {
            throw new IllegalArgumentException("Version not supported");
        }
        return this;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

