/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.FileAttachment;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeTypeConstants;

public class ZUGFeRD2PullProvider
implements IXMLProvider {
    protected byte[] zugferdData;
    protected IExportableTransaction trans;
    protected TransactionCalculator calc;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName("EN16931");

    @Override
    public void setTest() {
    }

    protected String vatFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    protected String currencyFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    protected String priceFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    protected String quantityFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    @Override
    public byte[] getXML() {
        byte[] res = this.zugferdData;
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText(new String(this.zugferdData));
        }
        catch (DocumentException e1) {
            Logger.getLogger(ZUGFeRD2PullProvider.class.getName()).log(Level.SEVERE, null, e1);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setTrimText(false);
            XMLWriter writer = new XMLWriter(sw, format);
            writer.write(document);
            res = sw.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.getLogger(ZUGFeRD2PullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
        return res;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    protected String getTradePartyAsXML(IZUGFeRDExportableTradeParty party, boolean isSender, boolean isShipToTradeParty) {
        String xml = "";
        if (party.getID() != null) {
            xml = xml + "<ram:ID>" + XMLTools.encodeXML(party.getID()) + "</ram:ID>";
        }
        if (party.getGlobalIDScheme() != null && party.getGlobalID() != null) {
            xml = xml + "<ram:GlobalID schemeID=\"" + XMLTools.encodeXML(party.getGlobalIDScheme()) + "\">" + XMLTools.encodeXML(party.getGlobalID()) + "</ram:GlobalID>";
        }
        xml = xml + "<ram:Name>" + XMLTools.encodeXML(party.getName()) + "</ram:Name>";
        if (party.getLegalOrganisation() != null) {
            xml = xml + "<ram:SpecifiedLegalOrganization> ";
            xml = xml + "  <ram:ID schemeID=\"" + XMLTools.encodeXML(party.getLegalOrganisation().getSchemeID()) + "\">" + XMLTools.encodeXML(party.getLegalOrganisation().getID()) + "</ram:ID>";
            xml = xml + "</ram:SpecifiedLegalOrganization>";
        }
        if (party.getContact() != null && (isSender || this.profile == Profiles.getByName("Extended") || this.profile == Profiles.getByName("XRechnung"))) {
            xml = xml + "<ram:DefinedTradeContact>";
            if (party.getContact().getName() != null) {
                xml = xml + "<ram:PersonName>" + XMLTools.encodeXML(party.getContact().getName()) + "</ram:PersonName>";
            }
            if (party.getContact().getPhone() != null) {
                xml = xml + "<ram:TelephoneUniversalCommunication><ram:CompleteNumber>" + XMLTools.encodeXML(party.getContact().getPhone()) + "</ram:CompleteNumber></ram:TelephoneUniversalCommunication>";
            }
            if (party.getContact().getFax() != null && this.profile == Profiles.getByName("Extended")) {
                xml = xml + "<ram:FaxUniversalCommunication><ram:CompleteNumber>" + XMLTools.encodeXML(party.getContact().getFax()) + "</ram:CompleteNumber></ram:FaxUniversalCommunication>";
            }
            if (party.getContact().getEMail() != null) {
                xml = xml + "<ram:EmailURIUniversalCommunication><ram:URIID>" + XMLTools.encodeXML(party.getContact().getEMail()) + "</ram:URIID></ram:EmailURIUniversalCommunication>";
            }
            xml = xml + "</ram:DefinedTradeContact>";
        }
        xml = xml + "<ram:PostalTradeAddress>";
        if (party.getZIP() != null) {
            xml = xml + "<ram:PostcodeCode>" + XMLTools.encodeXML(party.getZIP()) + "</ram:PostcodeCode>";
        }
        if (party.getStreet() != null) {
            xml = xml + "<ram:LineOne>" + XMLTools.encodeXML(party.getStreet()) + "</ram:LineOne>";
        }
        if (party.getAdditionalAddress() != null) {
            xml = xml + "<ram:LineTwo>" + XMLTools.encodeXML(party.getAdditionalAddress()) + "</ram:LineTwo>";
        }
        if (party.getAdditionalAddressExtension() != null) {
            xml = xml + "<ram:LineThree>" + XMLTools.encodeXML(party.getAdditionalAddressExtension()) + "</ram:LineThree>";
        }
        if (party.getLocation() != null) {
            xml = xml + "<ram:CityName>" + XMLTools.encodeXML(party.getLocation()) + "</ram:CityName>";
        }
        xml = xml + "<ram:CountryID>" + XMLTools.encodeXML(party.getCountry()) + "</ram:CountryID></ram:PostalTradeAddress>";
        if (party.getVATID() != null && !isShipToTradeParty) {
            xml = xml + "<ram:SpecifiedTaxRegistration><ram:ID schemeID=\"VA\">" + XMLTools.encodeXML(party.getVATID()) + "</ram:ID></ram:SpecifiedTaxRegistration>";
        }
        if (party.getTaxID() != null && !isShipToTradeParty) {
            xml = xml + "<ram:SpecifiedTaxRegistration><ram:ID schemeID=\"FC\">" + XMLTools.encodeXML(party.getTaxID()) + "</ram:ID></ram:SpecifiedTaxRegistration>";
        }
        return xml;
    }

    protected String getAllowanceChargeStr(IZUGFeRDAllowanceCharge allowance, IAbsoluteValueProvider item) {
        String percentage = "";
        String chargeIndicator = "false";
        if (allowance.getPercent() != null && this.profile == Profiles.getByName("Extended")) {
            percentage = "<ram:CalculationPercent>" + this.vatFormat(allowance.getPercent()) + "</ram:CalculationPercent>";
            percentage = percentage + "<ram:BasisAmount>" + item.getValue() + "</ram:BasisAmount>";
        }
        if (allowance.isCharge()) {
            chargeIndicator = "true";
        }
        String reason = "";
        if (allowance.getReason() != null && this.profile == Profiles.getByName("Extended")) {
            reason = "<ram:Reason>" + XMLTools.encodeXML(allowance.getReason()) + "</ram:Reason>";
        }
        String allowanceChargeStr = "<ram:AppliedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>" + chargeIndicator + "</udt:Indicator></ram:ChargeIndicator>" + percentage + "<ram:ActualAmount>" + this.priceFormat(allowance.getTotalAmount(item)) + "</ram:ActualAmount>" + reason + "</ram:AppliedTradeAllowanceCharge>";
        return allowanceChargeStr;
    }

    protected String getItemTotalAllowanceChargeStr(IZUGFeRDAllowanceCharge allowance, IAbsoluteValueProvider item) {
        String percentage = "";
        String chargeIndicator = "false";
        if (allowance.getPercent() != null && this.profile == Profiles.getByName("Extended")) {
            percentage = "<ram:CalculationPercent>" + this.vatFormat(allowance.getPercent()) + "</ram:CalculationPercent>";
            percentage = percentage + "<ram:BasisAmount>" + item.getValue() + "</ram:BasisAmount>";
        }
        if (allowance.isCharge()) {
            chargeIndicator = "true";
        }
        String itemTotalAllowanceChargeStr = "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>" + chargeIndicator + "</udt:Indicator></ram:ChargeIndicator>" + percentage + "<ram:ActualAmount>" + this.currencyFormat(allowance.getTotalAmount(item)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(allowance.getReason()) + "</ram:Reason></ram:SpecifiedTradeAllowanceCharge>";
        return itemTotalAllowanceChargeStr;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = XMLTools.encodeXML(trans.getPaymentTermDescription());
        }
        if (this.paymentTermsDescription == null && trans.getDocumentCode() != "384" && trans.getDocumentCode() != "381") {
            this.paymentTermsDescription = "Zahlbar ohne Abzug bis " + germanDateFormat.format(trans.getDueDate());
        }
        String senderReg = "";
        if (trans.getOwnOrganisationFullPlaintextInfo() != null) {
            senderReg = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getOwnOrganisationFullPlaintextInfo()) + "</ram:Content><ram:SubjectCode>REG</ram:SubjectCode></ram:IncludedNote>";
        }
        String rebateAgreement = "";
        if (trans.rebateAgreementExists()) {
            rebateAgreement = "<ram:IncludedNote><ram:Content>Es bestehen Rabatt- und Bonusvereinbarungen.</ram:Content><ram:SubjectCode>AAK</ram:SubjectCode></ram:IncludedNote>";
        }
        String subjectNote = "";
        if (trans.getSubjectNote() != null) {
            subjectNote = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getSubjectNote()) + "</ram:Content></ram:IncludedNote>";
        }
        String typecode = "380";
        if (trans.getDocumentCode() != null) {
            typecode = trans.getDocumentCode();
        }
        String notes = "";
        if (trans.getNotes() != null) {
            for (String currentNote : trans.getNotes()) {
                notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
            }
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rsm:CrossIndustryInvoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:rsm=\"urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100\" xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100\" xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100\" xmlns:qdt=\"urn:un:unece:uncefact:data:standard:QualifiedDataType:100\"><!-- generated by: mustangproject.org v" + ZUGFeRD2PullProvider.class.getPackage().getImplementationVersion() + "--><rsm:ExchangedDocumentContext><ram:GuidelineSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:GuidelineSpecifiedDocumentContextParameter></rsm:ExchangedDocumentContext><rsm:ExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:TypeCode>" + typecode + "</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + notes + subjectNote + rebateAgreement + senderReg + "</rsm:ExchangedDocument><rsm:SupplyChainTradeTransaction>";
        int lineID = 0;
        for (IZUGFeRDExportableItem iZUGFeRDExportableItem : trans.getZFItems()) {
            int n;
            ++lineID;
            if (iZUGFeRDExportableItem.getProduct().getTaxExemptionReason() != null) {
                exemptionReason = "<ram:ExemptionReason>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getTaxExemptionReason()) + "</ram:ExemptionReason>";
            }
            notes = "";
            if (iZUGFeRDExportableItem.getNotes() != null) {
                for (String currentNote : iZUGFeRDExportableItem.getNotes()) {
                    notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
                }
            }
            LineCalculator lc = new LineCalculator(iZUGFeRDExportableItem);
            if (this.getProfile() == Profiles.getByName("Minimum") || this.getProfile() == Profiles.getByName("BasicWL")) continue;
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineID + "</ram:LineID>" + notes + "</ram:AssociatedDocumentLineDocument><ram:SpecifiedTradeProduct>";
            if (iZUGFeRDExportableItem.getProduct().getGlobalIDScheme() != null && iZUGFeRDExportableItem.getProduct().getGlobalID() != null) {
                xml = xml + "<ram:GlobalID schemeID=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getGlobalIDScheme()) + "\">" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getGlobalID()) + "</ram:GlobalID>";
            }
            if (iZUGFeRDExportableItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (iZUGFeRDExportableItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            String allowanceChargeStr = "";
            if (iZUGFeRDExportableItem.getItemAllowances() != null && iZUGFeRDExportableItem.getItemAllowances().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = iZUGFeRDExportableItem.getItemAllowances();
                int n2 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n2; ++n) {
                    IZUGFeRDAllowanceCharge allowance = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(allowance, iZUGFeRDExportableItem);
                }
            }
            if (iZUGFeRDExportableItem.getItemCharges() != null && iZUGFeRDExportableItem.getItemCharges().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = iZUGFeRDExportableItem.getItemCharges();
                int n3 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n3; ++n) {
                    IZUGFeRDAllowanceCharge charge = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(charge, iZUGFeRDExportableItem);
                }
            }
            String itemTotalAllowanceChargeStr = "";
            if (iZUGFeRDExportableItem.getItemTotalAllowances() != null && iZUGFeRDExportableItem.getItemTotalAllowances().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = iZUGFeRDExportableItem.getItemTotalAllowances();
                n = iZUGFeRDAllowanceChargeArray.length;
                for (int i = 0; i < n; ++i) {
                    IZUGFeRDAllowanceCharge itemTotalAllowance = iZUGFeRDAllowanceChargeArray[i];
                    itemTotalAllowanceChargeStr = itemTotalAllowanceChargeStr + this.getItemTotalAllowanceChargeStr(itemTotalAllowance, iZUGFeRDExportableItem);
                }
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getName()) + "</ram:Name><ram:Description>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getDescription()) + "</ram:Description></ram:SpecifiedTradeProduct><ram:SpecifiedLineTradeAgreement>";
            if (iZUGFeRDExportableItem.getReferencedDocuments() != null) {
                IReferencedDocument[] iReferencedDocumentArray = iZUGFeRDExportableItem.getReferencedDocuments();
                n = iReferencedDocumentArray.length;
                for (int i = 0; i < n; ++i) {
                    IReferencedDocument currentReferencedDocument = iReferencedDocumentArray[i];
                    xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(currentReferencedDocument.getIssuerAssignedID()) + "</ram:IssuerAssignedID><ram:TypeCode>" + XMLTools.encodeXML(currentReferencedDocument.getTypeCode()) + "</ram:TypeCode><ram:ReferenceTypeCode>" + XMLTools.encodeXML(currentReferencedDocument.getReferenceTypeCode()) + "</ram:ReferenceTypeCode></ram:AdditionalReferencedDocument>";
                }
            }
            if (iZUGFeRDExportableItem.getBuyerOrderReferencedDocumentLineID() != null) {
                xml = xml + "<ram:BuyerOrderReferencedDocument> <ram:LineID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getBuyerOrderReferencedDocumentLineID()) + "</ram:LineID></ram:BuyerOrderReferencedDocument>";
            }
            xml = xml + "<ram:GrossPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lc.getPriceGross()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getBasisQuantity()) + "</ram:BasisQuantity>" + allowanceChargeStr + "</ram:GrossPriceProductTradePrice><ram:NetPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lc.getPrice()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getBasisQuantity()) + "</ram:BasisQuantity></ram:NetPriceProductTradePrice></ram:SpecifiedLineTradeAgreement><ram:SpecifiedLineTradeDelivery><ram:BilledQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getQuantity()) + "</ram:BilledQuantity></ram:SpecifiedLineTradeDelivery><ram:SpecifiedLineTradeSettlement><ram:ApplicableTradeTax><ram:TypeCode>VAT</ram:TypeCode>" + exemptionReason + "<ram:CategoryCode>" + iZUGFeRDExportableItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(iZUGFeRDExportableItem.getProduct().getVATPercent()) + "</ram:RateApplicablePercent></ram:ApplicableTradeTax>";
            if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom() != null || iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + itemTotalAllowanceChargeStr;
            xml = xml + "<ram:SpecifiedTradeSettlementLineMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementLineMonetarySummation>";
            if (iZUGFeRDExportableItem.getAdditionalReferencedDocumentID() != null) {
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + iZUGFeRDExportableItem.getAdditionalReferencedDocumentID() + "</ram:IssuerAssignedID><ram:TypeCode>130</ram:TypeCode></ram:AdditionalReferencedDocument>";
            }
            xml = xml + "</ram:SpecifiedLineTradeSettlement></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "<ram:ApplicableHeaderTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>" + this.getTradePartyAsXML(trans.getSender(), true, false) + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "   <ram:SellerOrderReferencedDocument>       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID>   </ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "   <ram:BuyerOrderReferencedDocument>       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID>   </ram:BuyerOrderReferencedDocument>";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "   <ram:ContractReferencedDocument>       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID>    </ram:ContractReferencedDocument>";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment fileAttachment : trans.getAdditionalReferencedDocuments()) {
                String documentContent = new String(Base64.getEncoder().encodeToString(fileAttachment.getData()));
                xml = xml + "  <ram:AdditionalReferencedDocument>    <ram:IssuerAssignedID>" + fileAttachment.getFilename() + "</ram:IssuerAssignedID>    <ram:TypeCode>916</ram:TypeCode>    <ram:Name>" + fileAttachment.getDescription() + "</ram:Name>    <ram:AttachmentBinaryObject mimeCode=\"" + fileAttachment.getMimetype() + "\"\n      filename=\"" + fileAttachment.getFilename() + "\">" + documentContent + "</ram:AttachmentBinaryObject>  </ram:AdditionalReferencedDocument>";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "   <ram:SpecifiedProcuringProject>       <ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "       <ram:Name >" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>";
            }
            xml = xml + "    </ram:SpecifiedProcuringProject>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeAgreement>";
        xml = xml + "<ram:ApplicableHeaderTradeDelivery>";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        if (trans.getDeliveryDate() != null) {
            xml = xml + "<ram:ActualDeliverySupplyChainEvent><ram:OccurrenceDateTime>";
            xml = xml + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate());
            xml = xml + "</ram:OccurrenceDateTime>";
            xml = xml + "            </ram:ActualDeliverySupplyChainEvent>";
        } else if (trans.getDocumentCode() != "381" && this.getProfile() != Profiles.getByName("Minimum")) {
            throw new IllegalStateException("No delivery date provided");
        }
        if (trans.getDespatchAdviceReferencedDocumentID() != null) {
            xml = xml + "<ram:DespatchAdviceReferencedDocument>";
            xml = xml + "<ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getDespatchAdviceReferencedDocumentID()) + "</ram:IssuerAssignedID>";
            xml = xml + "</ram:DespatchAdviceReferencedDocument>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeDelivery>";
        xml = xml + "<ram:ApplicableHeaderTradeSettlement>";
        if (trans.getNumber() != null && this.getProfile() != Profiles.getByName("Minimum")) {
            xml = xml + "            <ram:PaymentReference>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:PaymentReference>";
        }
        xml = xml + "            <ram:InvoiceCurrencyCode>" + trans.getCurrency() + "</ram:InvoiceCurrencyCode>";
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlementPayment iZUGFeRDTradeSettlementPayment : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlementPayment == null) continue;
                hasDueDate = true;
                if (this.getProfile() == Profiles.getByName("Minimum")) continue;
                xml = xml + iZUGFeRDTradeSettlementPayment.getSettlementXML();
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                if (iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment) {
                    hasDueDate = true;
                }
                if (this.getProfile() == Profiles.getByName("Minimum")) continue;
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        if (trans.getDocumentCode() == "384" || trans.getDocumentCode() == "381") {
            hasDueDate = false;
        }
        HashMap<BigDecimal, VATAmount> VATPercentAmountMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
            VATAmount vATAmount = (VATAmount)VATPercentAmountMap.get(currentTaxPercent);
            if (vATAmount == null) continue;
            String amountCategoryCode = vATAmount.getCategoryCode();
            String amountDueDateTypeCode = vATAmount.getDueDateTypeCode();
            boolean displayExemptionReason = TaxCategoryCodeTypeConstants.CATEGORY_CODES_WITH_EXEMPTION_REASON.contains(amountCategoryCode);
            if (this.getProfile() == Profiles.getByName("Minimum")) continue;
            xml = xml + "<ram:ApplicableTradeTax><ram:CalculatedAmount>" + this.currencyFormat(vATAmount.getCalculated()) + "</ram:CalculatedAmount><ram:TypeCode>VAT</ram:TypeCode>" + (displayExemptionReason ? exemptionReason : "") + "<ram:BasisAmount>" + this.currencyFormat(vATAmount.getBasis()) + "</ram:BasisAmount><ram:CategoryCode>" + amountCategoryCode + "</ram:CategoryCode>" + (amountDueDateTypeCode != null ? "<ram:DueDateTypeCode>" + amountDueDateTypeCode + "</ram:DueDateTypeCode>" : "") + "<ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:ApplicableTradeTax>";
        }
        if (trans.getDetailedDeliveryPeriodFrom() != null || trans.getDetailedDeliveryPeriodTo() != null) {
            xml = xml + "<ram:BillingSpecifiedPeriod>";
            if (trans.getDetailedDeliveryPeriodFrom() != null) {
                xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
            }
            if (trans.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
            }
            xml = xml + "</ram:BillingSpecifiedPeriod>";
        }
        if (trans.getZFCharges() != null && trans.getZFCharges().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getChargesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + " <ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>true</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getChargesForPercent(currentTaxPercent)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getChargeReasonForPercent(currentTaxPercent)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>\t";
            }
        }
        if (trans.getZFAllowances() != null && trans.getZFAllowances().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getAllowancesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>false</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(currentTaxPercent)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getAllowanceReasonForPercent(currentTaxPercent)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>\t";
            }
        }
        if (trans.getPaymentTerms() == null && this.getProfile() != Profiles.getByName("Minimum") && (this.paymentTermsDescription != null || trans.getTradeSettlement() != null || hasDueDate)) {
            xml = xml + "<ram:SpecifiedTradePaymentTerms>";
            if (this.paymentTermsDescription != null) {
                xml = xml + "<ram:Description>" + this.paymentTermsDescription + "</ram:Description>";
            }
            if (trans.getTradeSettlement() != null) {
                void var15_32;
                IZUGFeRDTradeSettlement[] currentNote = trans.getTradeSettlement();
                int currentTaxPercent = currentNote.length;
                boolean bl = false;
                while (var15_32 < currentTaxPercent) {
                    IZUGFeRDTradeSettlement payment = currentNote[var15_32];
                    if (payment != null && payment instanceof IZUGFeRDTradeSettlementDebit) {
                        xml = xml + payment.getPaymentXML();
                    }
                    ++var15_32;
                }
            }
            if (hasDueDate && trans.getDueDate() != null) {
                xml = xml + "<ram:DueDateDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDueDate()) + "</ram:DueDateDateTime>";
            }
            xml = xml + "</ram:SpecifiedTradePaymentTerms>";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        String allowanceTotalLine = "<ram:AllowanceTotalAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(null)) + "</ram:AllowanceTotalAmount>";
        String chargesTotalLine = "<ram:ChargeTotalAmount>" + this.currencyFormat(this.calc.getChargesForPercent(null)) + "</ram:ChargeTotalAmount>";
        xml = xml + "<ram:SpecifiedTradeSettlementHeaderMonetarySummation>";
        if (this.getProfile() != Profiles.getByName("Minimum")) {
            xml = xml + "<ram:LineTotalAmount>" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount>";
            xml = xml + chargesTotalLine + allowanceTotalLine;
        }
        xml = xml + "<ram:TaxBasisTotalAmount>" + this.currencyFormat(this.calc.getTaxBasis()) + "</ram:TaxBasisTotalAmount><ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTaxBasis())) + "</ram:TaxTotalAmount><ram:GrandTotalAmount>" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount>";
        if (this.getProfile() != Profiles.getByName("Minimum")) {
            xml = xml + "             <ram:TotalPrepaidAmount>" + this.currencyFormat(this.calc.getTotalPrepaid()) + "</ram:TotalPrepaidAmount>";
        }
        xml = xml + "<ram:DuePayableAmount>" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTotalPrepaid())) + "</ram:DuePayableAmount></ram:SpecifiedTradeSettlementHeaderMonetarySummation>";
        if (trans.getInvoiceReferencedDocumentID() != null) {
            xml = xml + "   <ram:InvoiceReferencedDocument>       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getInvoiceReferencedDocumentID()) + "</ram:IssuerAssignedID>";
            if (trans.getInvoiceReferencedIssueDate() != null) {
                xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(trans.getInvoiceReferencedIssueDate()) + "</ram:FormattedIssueDateTime>";
            }
            xml = xml + "   </ram:InvoiceReferencedDocument>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeSettlement>";
        xml = xml + "</rsm:SupplyChainTradeTransaction></rsm:CrossIndustryInvoice>";
        try {
            byte[] byArray = xml.getBytes("UTF-8");
            this.zugferdData = XMLTools.removeBOM(byArray);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ZUGFeRD2PullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    private String buildPaymentTermsXml() {
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        if (paymentTerms == null) {
            return "";
        }
        String paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        Date dueDate = paymentTerms.getDueDate();
        if (dueDate != null && discountTerms != null && discountTerms.getBaseDate() != null) {
            throw new IllegalStateException("if paymentTerms.dueDate is specified, paymentTerms.discountTerms.baseDate has not to be specified");
        }
        paymentTermsXml = paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (dueDate != null) {
            paymentTermsXml = paymentTermsXml + "<ram:DueDateDateTime>";
            paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(dueDate);
            paymentTermsXml = paymentTermsXml + "</ram:DueDateDateTime>";
        }
        if (this.trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement payment : this.trans.getTradeSettlement()) {
                if (payment == null || !(payment instanceof IZUGFeRDTradeSettlementDebit)) continue;
                paymentTermsXml = paymentTermsXml + payment.getPaymentXML();
            }
        }
        if (discountTerms != null) {
            paymentTermsXml = paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

