/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.OXPullProvider;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;

public class DAPullProvider
extends ZUGFeRD2PullProvider
implements IXMLProvider {
    protected IExportableTransaction trans;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName(EStandard.despatchadvice, "pilot", 1);

    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String exemptionReason = "";
        String senderReg = "";
        if (trans.getOwnOrganisationFullPlaintextInfo() != null) {
            senderReg = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getOwnOrganisationFullPlaintextInfo()) + "</ram:Content><ram:SubjectCode>REG</ram:SubjectCode></ram:IncludedNote>";
        }
        String subjectNote = "";
        if (trans.getSubjectNote() != null) {
            subjectNote = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getSubjectNote()) + "</ram:Content></ram:IncludedNote>";
        }
        String typecode = "220";
        String notes = "";
        if (trans.getNotes() != null) {
            for (String string : trans.getNotes()) {
                notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(string) + "</ram:Content></ram:IncludedNote>";
            }
        }
        String testBooleanStr = "true";
        String xml = "<SCRDMCCBDACIDAMessageStructure\n        xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:25\"\n        xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:101\"\n        xmlns:px=\"urn:un:unece:uncefact:data:standard:SCRDMCCBDACIDAMessageStructure:1\">\n<px:ExchangedDocumentContext> <ram:TestIndicator><udt:Indicator>" + testBooleanStr + "</udt:Indicator></ram:TestIndicator>\n<ram:BusinessProcessSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:BusinessProcessSpecifiedDocumentContextParameter></px:ExchangedDocumentContext><px:ExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:TypeCode>" + "220" + "</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + notes + subjectNote + senderReg + "</px:ExchangedDocument><px:SupplyChainTradeTransaction>";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            int n;
            ++lineID;
            if (currentItem.getProduct().getTaxExemptionReason() != null) {
                // empty if block
            }
            notes = "";
            if (currentItem.getNotes() != null) {
                for (String currentNote : currentItem.getNotes()) {
                    notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
                }
            }
            LineCalculator lc = new LineCalculator(currentItem);
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineID + "</ram:LineID>" + notes + "</ram:AssociatedDocumentLineDocument><ram:SpecifiedTradeProduct>";
            if (currentItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (currentItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            String allowanceChargeStr = "";
            if (currentItem.getItemAllowances() != null && currentItem.getItemAllowances().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = currentItem.getItemAllowances();
                int n2 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n2; ++n) {
                    IZUGFeRDAllowanceCharge allowance = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(allowance, currentItem);
                }
            }
            if (currentItem.getItemCharges() != null && currentItem.getItemCharges().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = currentItem.getItemCharges();
                int n3 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n3; ++n) {
                    IZUGFeRDAllowanceCharge charge = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(charge, currentItem);
                }
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(currentItem.getProduct().getName()) + "</ram:Name><ram:Description>" + XMLTools.encodeXML(currentItem.getProduct().getDescription()) + "</ram:Description></ram:SpecifiedTradeProduct><ram:SpecifiedLineTradeDelivery><ram:DespatchedQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getQuantity()) + "</ram:DespatchedQuantity></ram:SpecifiedLineTradeDelivery><ram:SpecifiedLineTradeSettlement>";
            if (currentItem.getDetailedDeliveryPeriodFrom() != null || currentItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (currentItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (currentItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + "<ram:SpecifiedTradeSettlementLineMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementLineMonetarySummation>";
            xml = xml + "</ram:SpecifiedLineTradeSettlement></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "<ram:ApplicableHeaderTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>" + this.getTradePartyAsXML(trans.getSender(), true, false) + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:SellerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:BuyerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:BuyerOrderReferencedDocument>";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "<ram:ContractReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID></ram:ContractReferencedDocument>";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment f : trans.getAdditionalReferencedDocuments()) {
                String documentContent = new String(Base64.getEncoder().encodeToString(f.getData()));
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + f.getFilename() + "</ram:IssuerAssignedID><ram:TypeCode>916</ram:TypeCode><ram:Name>" + f.getDescription() + "</ram:Name><ram:AttachmentBinaryObject mimeCode=\"" + f.getMimetype() + "\"\nfilename=\"" + f.getFilename() + "\">" + documentContent + "</ram:AttachmentBinaryObject></ram:AdditionalReferencedDocument>";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "<ram:SpecifiedProcuringProject><ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "<ram:Name >" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>";
            }
            xml = xml + "</ram:SpecifiedProcuringProject>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeAgreement><ram:ApplicableHeaderTradeDelivery>";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        xml = xml + " <ram:ActualDespatchSupplyChainEvent>\n                <ram:OccurrenceDateTime>\n                    <udt:DateTimeString\n                            format=\"102\">" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate()) + "</udt:DateTimeString>\n                </ram:OccurrenceDateTime>\n            </ram:ActualDespatchSupplyChainEvent>";
        xml = xml + "</ram:ApplicableHeaderTradeDelivery>\n";
        xml = xml + "</px:SupplyChainTradeTransaction></SCRDMCCBDACIDAMessageStructure>";
        try {
            byte[] byArray = xml.getBytes("UTF-8");
            this.zugferdData = XMLTools.removeBOM(byArray);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(OXPullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    private String buildPaymentTermsXml() {
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        if (paymentTerms == null) {
            return "";
        }
        String paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        Date dueDate = paymentTerms.getDueDate();
        if (dueDate != null && discountTerms != null && discountTerms.getBaseDate() != null) {
            throw new IllegalStateException("if paymentTerms.dueDate is specified, paymentTerms.discountTerms.baseDate has not to be specified");
        }
        paymentTermsXml = paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (dueDate != null) {
            paymentTermsXml = paymentTermsXml + "<ram:DueDateDateTime>";
            paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(dueDate);
            paymentTermsXml = paymentTermsXml + "</ram:DueDateDateTime>";
        }
        if (discountTerms != null) {
            paymentTermsXml = paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

