/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.extractor;

import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.extractor.ByNameMultipleExtractor;
import org.assertj.core.extractor.ByNameSingleExtractor;
import org.assertj.core.extractor.ResultOfExtractor;
import org.assertj.core.extractor.ToStringExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.Strings;

public class Extractors {
    public static Extractor<Object, String> toStringMethod() {
        return new ToStringExtractor();
    }

    public static <F> Extractor<F, Object> byName(String fieldOrProperty) {
        return new ByNameSingleExtractor(fieldOrProperty);
    }

    public static <F> Extractor<F, Tuple> byName(String ... fieldsOrProperties) {
        return new ByNameMultipleExtractor(fieldsOrProperties);
    }

    public static <F> Extractor<F, Object> resultOf(String methodName) {
        return new ResultOfExtractor(methodName);
    }

    public static String extractedDescriptionOf(String ... propertiesOrFields) {
        return String.format("Extracted: %s", Strings.join(propertiesOrFields).with(", "));
    }

    public static String extractedDescriptionOfMethod(String method) {
        return String.format("Extracted: result of %s()", method);
    }
}

