/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class SingleAtomicIterator
implements AtomicIterator,
ReversibleIterator<AtomicValue>,
LastPositionFinder,
GroundedIterator<AtomicValue>,
LookaheadIterator<AtomicValue> {
    private AtomicValue item;
    boolean gone = false;

    public SingleAtomicIterator(AtomicValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.item = value;
    }

    @Override
    public boolean hasNext() {
        return !this.gone;
    }

    @Override
    public AtomicValue next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.item;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void close() {
    }

    public SingleAtomicIterator getReverseIterator() {
        return new SingleAtomicIterator(this.item);
    }

    @Override
    public GroundedValue materialize() {
        return this.item;
    }

    @Override
    public GroundedValue getResidue() throws XPathException {
        return this.gone ? EmptySequence.getInstance() : this.item;
    }

    @Override
    public int getProperties() {
        return 7;
    }
}

