/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;

public class ShallowSkipRuleSet
implements BuiltInRuleSet {
    private static ShallowSkipRuleSet THE_INSTANCE = new ShallowSkipRuleSet();

    public static ShallowSkipRuleSet getInstance() {
        return THE_INSTANCE;
    }

    private ShallowSkipRuleSet() {
    }

    @Override
    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, XPathContext context, Location locationId) throws XPathException {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 1: {
                    TailCall tc;
                    XPathContextMajor c2 = context.newContext();
                    c2.setOrigin(this);
                    c2.trackFocus(node.iterateAxis((byte)2));
                    c2.setCurrentComponent(c2.getCurrentMode());
                    for (tc = c2.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                    }
                }
                case 9: {
                    TailCall tc;
                    XPathContextMajor c2 = context.newContext();
                    c2.setOrigin(this);
                    c2.trackFocus(node.iterateAxis((byte)3));
                    c2.setCurrentComponent(c2.getCurrentMode());
                    for (tc = c2.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                    }
                    return;
                }
            }
        } else if (item instanceof ArrayItem) {
            Sequence seq = ArrayFunctionSet.ArrayToSequence.toSequence((ArrayItem)item);
            SequenceIterator members = seq.iterate();
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.trackFocus(members);
            c2.setCurrentComponent(c2.getCurrentMode());
            for (TailCall tc = c2.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
            }
        }
    }

    @Override
    public int[] getActionForParentNodes(int nodeKind) {
        return new int[]{6, 7};
    }
}

