/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.EmptySequence;

public class ZeroOrOne<T extends Item>
implements GroundedValue<T> {
    private T item;
    private static ZeroOrOne<Item> EMPTY = new ZeroOrOne<Object>(null);

    public static <T extends Item> ZeroOrOne<T> empty() {
        return EMPTY;
    }

    public ZeroOrOne(T item) {
        this.item = item;
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.item == null ? "" : this.item.getStringValueCS();
    }

    @Override
    public String getStringValue() {
        return this.item == null ? "" : this.item.getStringValue();
    }

    @Override
    public T head() {
        return this.item;
    }

    @Override
    public int getLength() {
        return this.item == null ? 0 : 1;
    }

    @Override
    public T itemAt(int n) {
        if (n == 0 && this.item != null) {
            return this.item;
        }
        return null;
    }

    @Override
    public GroundedValue<T> subsequence(int start, int length) {
        if (this.item != null && start <= 0 && start + length > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    @Override
    public UnfailingIterator<T> iterate() {
        return SingletonIterator.makeIterator(this.item);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.item);
    }

    public String toString() {
        return this.item == null ? "null" : this.item.toString();
    }

    @Override
    public GroundedValue<T> reduce() {
        if (this.item == null) {
            return EmptySequence.getInstance();
        }
        return this;
    }
}

