/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public final class DocumentOrderIterator<T extends NodeInfo>
implements SequenceIterator<T>,
Sortable {
    private SequenceIterator<T> iterator;
    private ArrayList<T> sequence;
    private ItemOrderComparer comparer;
    private T current = null;

    public DocumentOrderIterator(SequenceIterator<? extends T> base, ItemOrderComparer comparer) throws XPathException {
        this.comparer = comparer;
        int len = (base.getProperties() & 2) == 0 ? 50 : ((LastPositionFinder)((Object)base)).getLength();
        this.sequence = new ArrayList(len);
        base.forEachOrFail(this.sequence::add);
        if (this.sequence.size() > 1) {
            GenericSorter.quickSort(0, this.sequence.size(), this);
        }
        this.iterator = new ListIterator<T>(this.sequence);
    }

    private DocumentOrderIterator() {
    }

    @Override
    public int compare(int a, int b) {
        return this.comparer.compare((Item)this.sequence.get(a), (Item)this.sequence.get(b));
    }

    @Override
    public void swap(int a, int b) {
        NodeInfo temp = (NodeInfo)this.sequence.get(a);
        this.sequence.set(a, this.sequence.get(b));
        this.sequence.set(b, temp);
    }

    @Override
    public T next() throws XPathException {
        NodeInfo next;
        do {
            if ((next = (NodeInfo)this.iterator.next()) != null) continue;
            this.current = null;
            return null;
        } while (next.equals(this.current));
        this.current = next;
        return this.current;
    }

    @Override
    public int getProperties() {
        return 0;
    }

    @Override
    public void close() {
    }
}

