/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Optimizer;

public class ExpressionVisitor {
    private StaticContext staticContext;
    private boolean optimizeForStreaming = false;
    private boolean optimizeForPatternMatching = false;
    private Configuration config;
    private Optimizer optimizer;
    private int depth = 0;
    private static final int MAX_DEPTH = 500;

    public ExpressionVisitor(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public static ExpressionVisitor make(StaticContext env) {
        ExpressionVisitor visitor = new ExpressionVisitor(env.getConfiguration());
        visitor.setStaticContext(env);
        return visitor;
    }

    public void issueWarning(String message, Location locator) {
        this.staticContext.issueWarning(message, locator);
    }

    public XPathContext makeDynamicContext() {
        return this.staticContext.makeEarlyEvaluationContext();
    }

    public Optimizer obtainOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = this.config.obtainOptimizer(this.staticContext.getOptimizerOptions());
        }
        return this.optimizer;
    }

    public void setOptimizeForStreaming(boolean option) {
        this.optimizeForStreaming = option;
    }

    public boolean isOptimizeForStreaming() {
        return this.optimizeForStreaming;
    }

    public void setOptimizeForPatternMatching(boolean option) {
        this.optimizeForPatternMatching = option;
    }

    public boolean isOptimizeForPatternMatching() {
        return this.optimizeForPatternMatching;
    }

    public String getTargetEdition() {
        return this.staticContext.getPackageData().getTargetEdition();
    }

    public boolean incrementAndTestDepth() {
        return this.depth++ < 500;
    }

    public void decrementDepth() {
        --this.depth;
    }
}

