/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class ErrorExpression
extends Expression {
    private XPathException exception;
    private String message;
    private String errorCode;
    private boolean isTypeError;
    private Expression original;

    public ErrorExpression() {
        this("Unspecified error", "XXXX9999", false);
    }

    public ErrorExpression(String message, String errorCode, boolean isTypeError) {
        this.message = message;
        this.errorCode = errorCode;
        this.isTypeError = isTypeError;
    }

    public ErrorExpression(XPathException exception) {
        this.exception = exception;
        this.message = exception.getMessage();
        this.errorCode = exception.getErrorCodeLocalPart();
    }

    public XPathException getException() {
        return this.exception;
    }

    public boolean isTypeError() {
        return this.exception == null ? this.isTypeError : this.exception.isTypeError();
    }

    public String getMessage() {
        return this.exception == null ? this.message : this.exception.getMessage();
    }

    public String getErrorCodeLocalPart() {
        return this.exception == null ? this.errorCode : this.exception.getErrorCodeLocalPart();
    }

    public void setOriginalExpression(Expression original) {
        this.original = original;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 3;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.exception != null) {
            XPathException err = new XPathException(this.exception);
            err.setLocation(this.exception.getLocator());
            err.maybeSetLocation(this.getLocation());
            err.setErrorCodeQName(this.exception.getErrorCodeQName());
            err.setXPathContext(this.exception.getXPathContext());
            err.maybeSetContext(context);
            err.setIsTypeError(this.exception.isTypeError());
            err.setIsStaticError(this.exception.isStaticError());
            err.setIsGlobalError(this.exception.isGlobalError());
            throw err;
        }
        XPathException err = new XPathException(this.message);
        err.setLocation(this.getLocation());
        err.setErrorCode(this.errorCode);
        err.setXPathContext(context);
        err.setIsTypeError(this.isTypeError);
        throw err;
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        this.evaluateItem(context);
        return null;
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        if (this.exception != null) {
            ErrorExpression e2 = new ErrorExpression(this.exception);
            e2.setOriginalExpression(this.original);
            ExpressionTool.copyLocationInfo(this, e2);
            return e2;
        }
        ErrorExpression e2 = new ErrorExpression(this.message, this.errorCode, this.isTypeError);
        e2.setOriginalExpression(this.original);
        ExpressionTool.copyLocationInfo(this, e2);
        return e2;
    }

    @Override
    public String getExpressionName() {
        return "errorExpr";
    }

    @Override
    public String toString() {
        if (this.original != null) {
            return this.original.toString();
        }
        return "error(\"" + this.message + "\")";
    }

    @Override
    public String toShortString() {
        if (this.original != null) {
            return this.original.toShortString();
        }
        return "error(\"" + this.message + "\")";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("error", this);
        destination.emitAttribute("message", this.exception == null ? this.message : this.exception.getMessage());
        destination.emitAttribute("code", this.exception == null ? this.errorCode : this.exception.getErrorCodeLocalPart());
        destination.emitAttribute("isTypeErr", this.isTypeError ? "0" : "1");
        destination.endElement();
    }
}

