/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class CastToUnion
extends UnaryExpression {
    private UnionType targetType;
    private boolean allowEmpty;

    public CastToUnion(Expression source, UnionType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public UnionType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        RoleDiagnostic role = new RoleDiagnostic(2, "cast as", 0);
        Expression operand = visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getBaseExpression(), atomicType, role, visitor);
        this.setBaseExpression(operand);
        if (operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                GroundedValue<? extends Item> av = this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()).materialize();
                return Literal.makeLiteral(av, this);
            }
            if (literalOperand.getLength() == 0) {
                if (this.allowEmpty) {
                    return operand;
                }
                XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
                err.setErrorCode("XPTY0004");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        int c = 16384;
        if (this.allowEmpty && Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            c |= 0x2000;
        }
        try {
            if (this.targetType.containsListType()) {
                c |= 0x2000;
                c |= 0x8000;
            }
        }
        catch (MissingComponentException e) {
            c |= 0x2000;
            c |= 0x8000;
        }
        return c;
    }

    @Override
    public ItemType getItemType() {
        if (this.targetType instanceof PlainType) {
            return this.targetType;
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return this.targetType.getUType();
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x800000;
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.getTargetType().isNamespaceSensitive() ? 2048 : 0;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CastToUnion c = new CastToUnion(this.getBaseExpression().copy(rebindings), this.targetType, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, c);
        c.setRetainedStaticContext(this.getRetainedStaticContext());
        return c;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        AtomicValue value = (AtomicValue)this.getBaseExpression().evaluateItem(context);
        if (value == null) {
            if (this.allowEmpty) {
                return null;
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocation(this.getLocation());
            e.setErrorCode("XPTY0004");
            throw e;
        }
        try {
            AtomicSequence result = CastToUnion.cast(value, this.targetType, this.getRetainedStaticContext(), rules);
            return result.iterate();
        }
        catch (XPathException err) {
            err.maybeSetContext(context);
            err.maybeSetLocation(this.getLocation());
            err.setErrorCode("FORG0001");
            throw err;
        }
    }

    public static boolean castable(AtomicValue value, UnionType targetType, NamespaceResolver nsResolver, XPathContext context) {
        try {
            CastToUnion.cast(value, targetType, nsResolver, context.getConfiguration().getConversionRules());
            return true;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public static AtomicSequence cast(AtomicValue value, UnionType targetType, NamespaceResolver nsResolver, ConversionRules rules) throws XPathException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
            try {
                return targetType.getTypedValue(value.getStringValueCS(), nsResolver, rules);
            }
            catch (ValidationException e) {
                e.setErrorCode("FORG0001");
                throw e;
            }
        }
        AtomicType label = value.getItemType();
        Iterable<PlainType> memberTypes = targetType.getPlainMemberTypes();
        for (PlainType member : memberTypes) {
            if (!label.equals(member)) continue;
            return value;
        }
        for (PlainType member : memberTypes) {
            AtomicType t = label;
            while (t != null) {
                if (t.equals(member)) {
                    return value;
                }
                t = t.getBaseType() instanceof AtomicType ? (AtomicType)t.getBaseType() : null;
            }
        }
        for (PlainType type : memberTypes) {
            ConversionResult result;
            Converter c;
            if (!(type instanceof AtomicType) || (c = rules.getConverter(value.getItemType(), (AtomicType)type)) == null || !((result = c.convert(value)) instanceof AtomicValue)) continue;
            return (AtomicValue)result;
        }
        throw new XPathException("Cannot convert the supplied value to " + targetType.getDescription(), "FORG0001");
    }

    @Override
    public String getExpressionName() {
        return "castToUnion";
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastToUnion && this.targetType == ((CastToUnion)other).targetType && this.allowEmpty == ((CastToUnion)other).allowEmpty && ExpressionTool.equalOrNull(this.getRetainedStaticContext(), ((CastToUnion)other).getRetainedStaticContext());
    }

    @Override
    public int computeHashCode() {
        return super.computeHashCode() ^ this.targetType.hashCode();
    }

    @Override
    public String toString() {
        return this.targetType.getEQName() + "(" + this.getBaseExpression().toString() + ")";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("castToUnion", this);
        out.emitAttribute("as", this.targetType.toExportString());
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

