/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.compare.IComparable;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;

@Immutable
public final class XPathFunctionKey
implements IComparable<XPathFunctionKey> {
    private final QName m_aFunctionName;
    private final int m_nArity;

    public XPathFunctionKey(@Nonnull QName qName, @Nonnegative int n) {
        this.m_aFunctionName = ValueEnforcer.notNull(qName, "FunctionName");
        this.m_nArity = ValueEnforcer.isGE0(n, "Arity");
    }

    @Nonnull
    public QName getFunctionName() {
        return this.m_aFunctionName;
    }

    @Nonnegative
    public int getArity() {
        return this.m_nArity;
    }

    @Override
    public int compareTo(@Nonnull XPathFunctionKey xPathFunctionKey) {
        int n = CompareHelper.compare(this.m_aFunctionName.getNamespaceURI(), xPathFunctionKey.m_aFunctionName.getNamespaceURI());
        if (n == 0 && (n = CompareHelper.compare(this.m_aFunctionName.getLocalPart(), xPathFunctionKey.m_aFunctionName.getLocalPart())) == 0) {
            n = CompareHelper.compare(this.m_nArity, xPathFunctionKey.m_nArity);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XPathFunctionKey xPathFunctionKey = (XPathFunctionKey)object;
        return this.m_aFunctionName.equals(xPathFunctionKey.m_aFunctionName) && this.m_nArity == xPathFunctionKey.m_nArity;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFunctionName).append(this.m_nArity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("name", this.m_aFunctionName).append("arity", this.m_nArity).getToString();
    }
}

