/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLEmitter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLSerializer<NODETYPE> {
    public static final String DEFAULT_NAMESPACE_PREFIX_PREFIX = "ns";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXMLSerializer.class);
    protected final IXMLWriterSettings m_aSettings;
    protected final StringBuilder m_aIndent = new StringBuilder(32);
    protected final NamespaceStack m_aNSStack;
    private final ICommonsOrderedMap<String, String> m_aRootNSMap = new CommonsLinkedHashMap<String, String>();

    public AbstractXMLSerializer(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aSettings = ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        INamespaceContext iNamespaceContext = iXMLWriterSettings.getNamespaceContext();
        this.m_aNSStack = new NamespaceStack(iNamespaceContext);
        if (iXMLWriterSettings.isPutNamespaceContextPrefixesInRoot()) {
            if (iNamespaceContext instanceof IIterableNamespaceContext) {
                for (Map.Entry entry : ((IIterableNamespaceContext)iNamespaceContext).getPrefixToNamespaceURIMap().entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    this.m_aRootNSMap.put(string, string2);
                }
            } else {
                LOGGER.error("XMLWriter settings has 'putNamespaceContextPrefixesInRoot' set to 'true', but the 'NamespaceContext' instance does not implement the 'IIterableNamespaceContext' interface. This functionality therefore does not work.");
            }
        }
    }

    @Nonnull
    public final IXMLWriterSettings getSettings() {
        return this.m_aSettings;
    }

    protected final void handlePutNamespaceContextPrefixInRoot(@Nonnull Map<QName, String> map) {
        if (this.m_aSettings.isEmitNamespaces() && this.m_aNSStack.size() == 1 && this.m_aSettings.isPutNamespaceContextPrefixesInRoot()) {
            for (Map.Entry entry : this.m_aRootNSMap.entrySet()) {
                map.put(XMLHelper.getXMLNSAttrQName((String)entry.getKey()), (String)entry.getValue());
                this.m_aNSStack.addNamespaceMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected abstract void emitNode(@Nonnull XMLEmitter var1, @Nullable NODETYPE var2, @Nullable NODETYPE var3, @Nonnull NODETYPE var4, @Nullable NODETYPE var5);

    @Nonnull
    @OverrideOnDemand
    protected XMLEmitter createXMLEmitter(@Nonnull @WillNotClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        return new XMLEmitter(writer, iXMLWriterSettings);
    }

    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull XMLEmitter xMLEmitter) {
        this.emitNode(xMLEmitter, null, null, NODETYPE, null);
    }

    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull @WillNotClose OutputStream outputStream) {
        ValueEnforcer.notNull(NODETYPE, "Node");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        NonBlockingBufferedWriter nonBlockingBufferedWriter = new NonBlockingBufferedWriter(StreamHelper.createWriter(outputStream, this.m_aSettings.getCharset()));
        this.write(NODETYPE, nonBlockingBufferedWriter);
    }

    public final void write(@Nonnull NODETYPE NODETYPE, @Nonnull @WillNotClose Writer writer) {
        XMLEmitter xMLEmitter = this.createXMLEmitter(writer, this.m_aSettings);
        this.emitNode(xMLEmitter, null, null, NODETYPE, null);
        StreamHelper.flush(writer);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Settings", this.m_aSettings).append("Indent", this.m_aIndent.toString()).append("NamespaceStack", this.m_aNSStack).getToString();
    }

    protected static final class NamespaceStack {
        private final ICommonsList<NamespaceLevel> m_aStack = new CommonsArrayList<NamespaceLevel>();
        private final NamespaceContext m_aNamespaceCtx;

        public NamespaceStack(@Nonnull NamespaceContext namespaceContext) {
            this.m_aNamespaceCtx = namespaceContext;
        }

        public void push() {
            NamespaceLevel namespaceLevel = new NamespaceLevel();
            this.m_aStack.add(0, namespaceLevel);
        }

        public void addNamespaceMapping(@Nullable String string, @Nonnull @Nonempty String string2) {
            this.m_aStack.getFirst().addPrefixNamespaceMapping(string, string2);
        }

        public void pop() {
            this.m_aStack.removeFirst();
        }

        @Nonnegative
        public int size() {
            return this.m_aStack.size();
        }

        @Nullable
        private String _getDefaultNamespaceURI() {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string = namespaceLevel.getDefaultNamespaceURI();
                if (!StringHelper.hasText(string)) continue;
                return string;
            }
            return null;
        }

        @Nullable
        private String _getUsedPrefixOfNamespace(@Nonnull String string) {
            ValueEnforcer.notNull(string, "NamespaceURI");
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string2 = namespaceLevel.getPrefixOfNamespaceURI(string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        private boolean _containsNoNamespace() {
            return this.m_aStack.containsNone(NamespaceLevel::hasAnyNamespace);
        }

        private boolean _containsNoPrefix(@Nonnull String string) {
            return this.m_aStack.containsNone(namespaceLevel -> namespaceLevel.getNamespaceURIOfPrefix(string) != null);
        }

        @Nullable
        private String _getMappedPrefix(@Nonnull String string) {
            String string2;
            ValueEnforcer.notNull(string, "NamespaceURI");
            if (this.m_aNamespaceCtx != null && (string2 = this.m_aNamespaceCtx.getPrefix(string)) != null) {
                return string2;
            }
            return null;
        }

        @Nullable
        private String _createUniquePrefix() {
            if (this._containsNoNamespace()) {
                return null;
            }
            int n = 0;
            String string;
            while (!this._containsNoPrefix(string = AbstractXMLSerializer.DEFAULT_NAMESPACE_PREFIX_PREFIX + n)) {
                ++n;
            }
            return string;
        }

        @Nullable
        public String getElementNamespacePrefixToUse(@Nonnull String string, boolean bl, @Nonnull Map<QName, String> map) {
            String string2 = StringHelper.getNotNull(this._getDefaultNamespaceURI());
            if (string.equals(string2)) {
                return null;
            }
            String string3 = this._getUsedPrefixOfNamespace(string);
            if (!(string3 != null || bl && string.length() <= 0)) {
                string3 = this._getMappedPrefix(string);
                if (string3 == null && !bl) {
                    string3 = this._createUniquePrefix();
                }
                map.put(XMLHelper.getXMLNSAttrQName(string3), string);
                this.addNamespaceMapping(string3, string);
            }
            return string3;
        }

        @Nullable
        public String getAttributeNamespacePrefixToUse(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nonnull Map<QName, String> map) {
            String string4 = StringHelper.getNotNull(this._getDefaultNamespaceURI());
            if (string.equals(string4)) {
                return null;
            }
            String string5 = this._getUsedPrefixOfNamespace(string);
            if (string5 == null) {
                if ("http://www.w3.org/2000/xmlns/".equals(string)) {
                    string5 = string2;
                    if (!"xmlns".equals(string2)) {
                        map.put(XMLHelper.getXMLNSAttrQName(string5), string3);
                    }
                    this.addNamespaceMapping(string5, string3);
                } else {
                    string5 = this._getMappedPrefix(string);
                    if (string5 == null) {
                        if (string.length() == 0) {
                            return null;
                        }
                        string5 = this._createUniquePrefix();
                    }
                    if (!"xml".equals(string5)) {
                        map.put(XMLHelper.getXMLNSAttrQName(string5), string);
                    }
                    this.addNamespaceMapping(string5, string);
                }
            }
            return string5;
        }
    }

    protected static final class NamespaceLevel {
        private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceLevel.class);
        private String m_sDefaultNamespaceURI;
        private ICommonsMap<String, String> m_aURL2PrefixMap;

        @Nullable
        public String getNamespaceURIOfPrefix(@Nullable String string) {
            if (StringHelper.hasNoText(string)) {
                return this.m_sDefaultNamespaceURI;
            }
            if (this.m_aURL2PrefixMap != null) {
                for (Map.Entry entry : this.m_aURL2PrefixMap.entrySet()) {
                    if (!((String)entry.getValue()).equals(string)) continue;
                    return (String)entry.getKey();
                }
            }
            return null;
        }

        public void addPrefixNamespaceMapping(@Nullable String string, @Nonnull String string2) {
            String string3;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Adding namespace mapping " + string + ":" + string2);
            }
            if ((string3 = this.getNamespaceURIOfPrefix(string)) != null && !string3.equals(string2) && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Overwriting namespace prefix '" + string + "' to use URL '" + string2 + "' instead of '" + string3 + "'");
            }
            if (StringHelper.hasNoText(string)) {
                if (this.m_sDefaultNamespaceURI != null && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Overwriting default namespace '" + this.m_sDefaultNamespaceURI + "' with namespace '" + string2 + "'");
                }
                this.m_sDefaultNamespaceURI = string2;
            } else {
                if (this.m_aURL2PrefixMap == null) {
                    this.m_aURL2PrefixMap = new CommonsHashMap<String, String>();
                }
                this.m_aURL2PrefixMap.put(string2, string);
            }
        }

        @Nullable
        public String getDefaultNamespaceURI() {
            return this.m_sDefaultNamespaceURI;
        }

        @Nullable
        public String getPrefixOfNamespaceURI(@Nonnull String string) {
            if (string.equals(this.m_sDefaultNamespaceURI)) {
                return null;
            }
            return this.m_aURL2PrefixMap == null ? null : (String)this.m_aURL2PrefixMap.get(string);
        }

        @Nonnegative
        public int getNamespaceCount() {
            return (this.m_sDefaultNamespaceURI == null ? 0 : 1) + (this.m_aURL2PrefixMap == null ? 0 : this.m_aURL2PrefixMap.size());
        }

        public boolean hasAnyNamespace() {
            return this.m_sDefaultNamespaceURI != null || this.m_aURL2PrefixMap != null && !this.m_aURL2PrefixMap.isEmpty();
        }

        public String toString() {
            return new ToStringGenerator(this).append("defaultNSURI", this.m_sDefaultNamespaceURI).append("url2prefix", this.m_aURL2PrefixMap).getToString();
        }
    }
}

