/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.sax.ISAXErrorHandler;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSAXErrorHandler
implements ISAXErrorHandler {
    protected AbstractSAXErrorHandler() {
    }

    @Nonnull
    public static IError getSaxParseError(@Nonnull IErrorLevel iErrorLevel, @Nonnull SAXParseException sAXParseException) {
        return ((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(iErrorLevel)).setErrorLocation(SimpleLocation.create(sAXParseException))).setErrorText("[SAX] " + sAXParseException.getMessage())).setLinkedException(sAXParseException)).build();
    }

    protected abstract void internalLog(@Nonnull IErrorLevel var1, @Nonnull SAXParseException var2);

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        this.internalLog(EErrorLevel.WARN, sAXParseException);
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        this.internalLog(EErrorLevel.ERROR, sAXParseException);
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.internalLog(EErrorLevel.FATAL_ERROR, sAXParseException);
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

