/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubl22;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.ubl22.EUBL22DocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBL22DocumentTypes {
    private static final ICommonsMap<String, EUBL22DocumentType> s_aNamespace2DocType = new CommonsHashMap<String, EUBL22DocumentType>();
    private static final ICommonsMap<String, EUBL22DocumentType> s_aLocalName2DocType = new CommonsHashMap<String, EUBL22DocumentType>();
    private static final UBL22DocumentTypes s_aInstance;

    private UBL22DocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllNamespaces() {
        return s_aNamespace2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL22DocumentType getDocumentTypeOfNamespace(@Nullable String string) {
        return (EUBL22DocumentType)s_aNamespace2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfNamespace(@Nullable String string) {
        EUBL22DocumentType eUBL22DocumentType = UBL22DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL22DocumentType == null ? null : eUBL22DocumentType.getImplementationClass();
    }

    @Nullable
    public static EUBL22DocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ArrayHelper.findFirst(EUBL22DocumentType.values(), eUBL22DocumentType -> eUBL22DocumentType.getImplementationClass().equals(clazz));
    }

    @Nullable
    public static Schema getSchemaOfNamespace(@Nullable String string) {
        EUBL22DocumentType eUBL22DocumentType = UBL22DocumentTypes.getDocumentTypeOfNamespace(string);
        return eUBL22DocumentType == null ? null : eUBL22DocumentType.getSchema();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return s_aLocalName2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBL22DocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EUBL22DocumentType)s_aLocalName2DocType.get(string);
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBL22DocumentType eUBL22DocumentType = UBL22DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL22DocumentType == null ? null : eUBL22DocumentType.getImplementationClass();
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBL22DocumentType eUBL22DocumentType = UBL22DocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBL22DocumentType == null ? null : eUBL22DocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EUBL22DocumentType eUBL22DocumentType = UBL22DocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eUBL22DocumentType == null ? null : eUBL22DocumentType.getSchema();
    }

    static {
        for (EUBL22DocumentType eUBL22DocumentType : EUBL22DocumentType.values()) {
            String string = eUBL22DocumentType.getNamespaceURI();
            if (s_aNamespace2DocType.containsKey(string)) {
                throw new IllegalArgumentException("The namespace '" + string + "' is already mapped!");
            }
            s_aNamespace2DocType.put(string, eUBL22DocumentType);
            String string2 = eUBL22DocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey(string2)) {
                throw new IllegalArgumentException("The local name '" + string2 + "' is already mapped!");
            }
            s_aLocalName2DocType.put(string2, eUBL22DocumentType);
        }
        s_aInstance = new UBL22DocumentTypes();
    }
}

