/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.io.stream.ByteBufferOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.ENewLineMode;
import com.helger.xml.XMLFactory;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroSAXHandler;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.SafeXMLStreamWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformResultFactory;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

public interface IJAXBWriter<JAXBTYPE> {
    public static final boolean USE_JAXB_CHARSET_FIX = true;

    @Nullable
    public INamespaceContext getNamespaceContext();

    public boolean isFormattedOutput();

    @Nullable
    public Charset getCharset();

    default public boolean hasCharset() {
        return this.getCharset() != null;
    }

    @Nullable
    public String getIndentString();

    default public boolean hasIndentString() {
        return StringHelper.hasText(this.getIndentString());
    }

    @Nullable
    public String getSchemaLocation();

    default public boolean hasSchemaLocation() {
        return StringHelper.hasText(this.getSchemaLocation());
    }

    @Nullable
    public String getNoNamespaceSchemaLocation();

    default public boolean hasNoNamespaceSchemaLocation() {
        return StringHelper.hasText(this.getNoNamespaceSchemaLocation());
    }

    @Nonnull
    default public IXMLWriterSettings getXMLWriterSettings() {
        XMLWriterSettings xMLWriterSettings = new XMLWriterSettings().setNamespaceContext(this.getNamespaceContext()).setIndent(this.isFormattedOutput() ? EXMLSerializeIndent.INDENT_AND_ALIGN : EXMLSerializeIndent.NONE);
        if (this.hasIndentString()) {
            xMLWriterSettings.setIndentationString(this.getIndentString());
        }
        if (this.hasCharset()) {
            xMLWriterSettings.setCharset(this.getCharset());
        }
        return xMLWriterSettings.setNewLineMode(ENewLineMode.DEFAULT).setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING);
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull File file) {
        NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream(file);
        if (nonBlockingBufferedOutputStream == null) {
            return ESuccess.FAILURE;
        }
        return this.write(JAXBTYPE, nonBlockingBufferedOutputStream);
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull Path path) {
        return this.write(JAXBTYPE, path.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull @WillClose OutputStream outputStream) {
        try {
            ESuccess eSuccess = this.write(JAXBTYPE, SafeXMLStreamWriter.create(outputStream, this.getXMLWriterSettings()));
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull @WillClose Writer writer) {
        try {
            ESuccess eSuccess = this.write(JAXBTYPE, SafeXMLStreamWriter.create(writer, this.getXMLWriterSettings()));
            return eSuccess;
        }
        finally {
            StreamHelper.close(writer);
        }
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull ByteBuffer byteBuffer) {
        return this.write(JAXBTYPE, new ByteBufferOutputStream(byteBuffer, false));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IWritableResource iWritableResource) {
        OutputStream outputStream = iWritableResource.getOutputStream(EAppend.TRUNCATE);
        if (outputStream == null) {
            return ESuccess.FAILURE;
        }
        return this.write(JAXBTYPE, outputStream);
    }

    @Nonnull
    public ESuccess write(@Nonnull JAXBTYPE var1, @Nonnull IJAXBMarshaller<JAXBTYPE> var2);

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull Result result) {
        if (result instanceof StreamResult) {
            LoggerFactory.getLogger(IJAXBWriter.class).warn("Potentially invalid XML is created by using StreamResult object: {}", (Object)result);
        }
        return this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, result));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull ContentHandler contentHandler) {
        return this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, contentHandler));
    }

    @Nonnull
    default public ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull @WillClose XMLStreamWriter xMLStreamWriter) {
        ESuccess eSuccess = this.write(JAXBTYPE, (Marshaller marshaller, JAXBElement<JAXBTYPE> jAXBElement) -> marshaller.marshal((Object)jAXBElement, xMLStreamWriter));
        try {
            xMLStreamWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalStateException("Failed to flush XMLStreamWriter", xMLStreamException);
        }
        try {
            xMLStreamWriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalStateException("Failed to close XMLStreamWriter", xMLStreamException);
        }
        return eSuccess;
    }

    @Nullable
    default public Document getAsDocument(@Nonnull JAXBTYPE JAXBTYPE) {
        Document document = XMLFactory.newDocument();
        return this.write(JAXBTYPE, TransformResultFactory.create(document)).isSuccess() ? document : null;
    }

    @Nullable
    default public IMicroDocument getAsMicroDocument(@Nonnull JAXBTYPE JAXBTYPE) {
        MicroSAXHandler microSAXHandler = new MicroSAXHandler(false, null, true);
        return this.write(JAXBTYPE, microSAXHandler).isSuccess() ? microSAXHandler.getDocument() : null;
    }

    @Nullable
    default public IMicroElement getAsMicroElement(@Nonnull JAXBTYPE JAXBTYPE) {
        IMicroDocument iMicroDocument = this.getAsMicroDocument(JAXBTYPE);
        if (iMicroDocument == null) {
            return null;
        }
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        iMicroElement.detachFromParent();
        return iMicroElement;
    }

    @Nullable
    default public String getAsString(@Nonnull JAXBTYPE JAXBTYPE) {
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();){
            SafeXMLStreamWriter safeXMLStreamWriter = SafeXMLStreamWriter.create(nonBlockingStringWriter, this.getXMLWriterSettings());
            String string = this.write(JAXBTYPE, safeXMLStreamWriter).isSuccess() ? nonBlockingStringWriter.getAsString() : null;
            return string;
        }
    }

    @Nullable
    default public ByteBuffer getAsByteBuffer(@Nonnull JAXBTYPE JAXBTYPE) {
        try (ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();){
            ByteBuffer byteBuffer = this.write(JAXBTYPE, SafeXMLStreamWriter.create(byteBufferOutputStream, this.getXMLWriterSettings())).isFailure() ? null : byteBufferOutputStream.getBuffer();
            return byteBuffer;
        }
    }

    @Nullable
    default public byte[] getAsBytes(@Nonnull JAXBTYPE JAXBTYPE) {
        try (ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();){
            byte[] byArray = this.write(JAXBTYPE, SafeXMLStreamWriter.create(byteBufferOutputStream, this.getXMLWriterSettings())).isFailure() ? null : byteBufferOutputStream.getAsByteArray();
            return byArray;
        }
    }

    @Nullable
    default public NonBlockingByteArrayInputStream getAsInputStream(@Nonnull JAXBTYPE JAXBTYPE) {
        byte[] byArray = this.getAsBytes(JAXBTYPE);
        return byArray == null ? null : new NonBlockingByteArrayInputStream(byArray);
    }

    @FunctionalInterface
    public static interface IJAXBMarshaller<JAXBTYPE> {
        public void doMarshal(@Nonnull Marshaller var1, @Nonnull JAXBElement<JAXBTYPE> var2) throws JAXBException;
    }
}

