/*
 * Decompiled with CFR 0.152.
 */
package com.helger.en16931.cii2ubl;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.en16931.cii2ubl.AbstractCIIToUBLConverter;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CardAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ExternalReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.LocationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMandateType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ProjectReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CompanyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EmbeddedDocumentBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EndpointIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableRoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrimaryAccountNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import un.unece.uncefact.data.standard.crossindustryinvoice._100.CrossIndustryInvoiceType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.CreditorFinancialAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.CreditorFinancialInstitutionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.DebtorFinancialAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.DocumentLineDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LegalOrganizationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.NoteType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProcuringProjectType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProductCharacteristicType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProductClassificationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ReferencedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SpecifiedPeriodType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainEventType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeLineItemType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeTransactionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TaxRegistrationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAccountingAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAddressType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAllowanceChargeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeContactType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeCountryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePartyType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePaymentTermsType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePriceType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeProductType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementFinancialCardType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementHeaderMonetarySummationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementLineMonetarySummationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementPaymentMeansType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeTaxType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.UniversalCommunicationType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.BinaryObjectType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;

public class CIIToUBL21Converter
extends AbstractCIIToUBLConverter<CIIToUBL21Converter> {
    private static final String UBL_VERSION = "2.1";

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType _copyID(@Nullable IDType iDType) {
        return CIIToUBL21Converter._copyID(iDType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType());
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType _copyNote(@Nullable NoteType noteType) {
        if (noteType == null) {
            return null;
        }
        oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType noteType2 = new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType();
        StringBuilder stringBuilder = new StringBuilder();
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : noteType.getContent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(textType.getValue());
        }
        noteType2.setValue(stringBuilder.toString());
        return noteType2;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType _copyNote(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType) {
        return CIIToUBL21Converter._copyName(textType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType());
    }

    @Nullable
    private static DocumentReferenceType _convertDocumentReference(@Nullable ReferencedDocumentType referencedDocumentType, @Nonnull IErrorList iErrorList) {
        IExplicitlyCloneable iExplicitlyCloneable;
        if (referencedDocumentType == null) {
            return null;
        }
        String string = referencedDocumentType.getIssuerAssignedIDValue();
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        DocumentReferenceType documentReferenceType = new DocumentReferenceType();
        documentReferenceType.setID(string).setSchemeID(referencedDocumentType.getReferenceTypeCodeValue());
        FormattedDateTimeType formattedDateTimeType = referencedDocumentType.getFormattedIssueDateTime();
        if (formattedDateTimeType != null) {
            documentReferenceType.setIssueDate(CIIToUBL21Converter._parseDate(formattedDateTimeType.getDateTimeString(), iErrorList));
        }
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType iExplicitlyCloneable2 : referencedDocumentType.getName()) {
            iExplicitlyCloneable = new DocumentDescriptionType();
            ((TextType)iExplicitlyCloneable).setValue(iExplicitlyCloneable2.getValue());
            ((TextType)iExplicitlyCloneable).setLanguageID(iExplicitlyCloneable2.getLanguageID());
            ((TextType)iExplicitlyCloneable).setLanguageLocaleID(iExplicitlyCloneable2.getLanguageLocaleID());
            documentReferenceType.addDocumentDescription((DocumentDescriptionType)iExplicitlyCloneable);
        }
        if (referencedDocumentType.getAttachmentBinaryObjectCount() > 0) {
            BinaryObjectType binaryObjectType = referencedDocumentType.getAttachmentBinaryObjectAtIndex(0);
            AttachmentType attachmentType = new AttachmentType();
            iExplicitlyCloneable = new EmbeddedDocumentBinaryObjectType();
            ((com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType)iExplicitlyCloneable).setMimeCode(binaryObjectType.getMimeCode());
            ((com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType)iExplicitlyCloneable).setFilename(binaryObjectType.getFilename());
            ((com.helger.xsds.ccts.cct.schemamodule.BinaryObjectType)iExplicitlyCloneable).setValue(binaryObjectType.getValue());
            attachmentType.setEmbeddedDocumentBinaryObject((EmbeddedDocumentBinaryObjectType)iExplicitlyCloneable);
            String string2 = referencedDocumentType.getURIIDValue();
            if (StringHelper.hasText(string2)) {
                ExternalReferenceType externalReferenceType = new ExternalReferenceType();
                externalReferenceType.setURI(string2);
                attachmentType.setExternalReference(externalReferenceType);
            }
            documentReferenceType.setAttachment(attachmentType);
        }
        return documentReferenceType;
    }

    @Nonnull
    private static AddressType _convertPostalAddress(@Nonnull TradeAddressType tradeAddressType) {
        IExplicitlyCloneable iExplicitlyCloneable;
        AddressType addressType = new AddressType();
        addressType.setStreetName(tradeAddressType.getLineOneValue());
        if (StringHelper.hasText(tradeAddressType.getLineTwoValue())) {
            addressType.setAdditionalStreetName(tradeAddressType.getLineTwoValue());
        }
        if (StringHelper.hasText(tradeAddressType.getLineThreeValue())) {
            iExplicitlyCloneable = new AddressLineType();
            ((AddressLineType)iExplicitlyCloneable).setLine(tradeAddressType.getLineThreeValue());
            addressType.addAddressLine((AddressLineType)iExplicitlyCloneable);
        }
        addressType.setCityName(tradeAddressType.getCityNameValue());
        addressType.setPostalZone(tradeAddressType.getPostcodeCodeValue());
        if (tradeAddressType.hasCountrySubDivisionNameEntries()) {
            addressType.setCountrySubentity(tradeAddressType.getCountrySubDivisionNameAtIndex(0).getValue());
        }
        if (StringHelper.hasText(tradeAddressType.getCountryIDValue())) {
            iExplicitlyCloneable = new CountryType();
            ((CountryType)iExplicitlyCloneable).setIdentificationCode(tradeAddressType.getCountryIDValue());
            addressType.setCountry((CountryType)iExplicitlyCloneable);
        }
        return addressType;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType _extractPartyID(@Nonnull TradePartyType tradePartyType) {
        IDType iDType = tradePartyType.hasGlobalIDEntries() ? tradePartyType.getGlobalIDAtIndex(0) : (tradePartyType.hasIDEntries() ? tradePartyType.getIDAtIndex(0) : null);
        return iDType == null ? null : CIIToUBL21Converter._copyID(iDType);
    }

    private static void _addPartyID(@Nonnull oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType, @Nonnull PartyType partyType) {
        if (iDType != null && !CollectionHelper.containsAny(partyType.getPartyIdentification(), partyIdentificationType -> EqualsHelper.equals(iDType, partyIdentificationType.getID()))) {
            PartyIdentificationType partyIdentificationType2 = new PartyIdentificationType();
            partyIdentificationType2.setID(iDType);
            partyType.addPartyIdentification(partyIdentificationType2);
        }
    }

    @Nonnull
    private static PartyType _convertParty(@Nonnull TradePartyType tradePartyType) {
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        PartyType partyType = new PartyType();
        if (tradePartyType.hasURIUniversalCommunicationEntries()) {
            iExplicitlyCloneable2 = tradePartyType.getURIUniversalCommunicationAtIndex(0);
            partyType.setEndpointID(CIIToUBL21Converter._copyID(iExplicitlyCloneable2.getURIID(), new EndpointIDType()));
        }
        CIIToUBL21Converter._addPartyID(CIIToUBL21Converter._extractPartyID(tradePartyType), partyType);
        iExplicitlyCloneable2 = tradePartyType.getName();
        if (iExplicitlyCloneable2 != null) {
            iExplicitlyCloneable = new PartyNameType();
            ((PartyNameType)iExplicitlyCloneable).setName(CIIToUBL21Converter._copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2, new NameType()));
            partyType.addPartyName((PartyNameType)iExplicitlyCloneable);
        }
        if ((iExplicitlyCloneable = tradePartyType.getPostalTradeAddress()) != null) {
            partyType.setPostalAddress(CIIToUBL21Converter._convertPostalAddress((TradeAddressType)iExplicitlyCloneable));
        }
        return partyType;
    }

    @Nonnull
    private PartyTaxSchemeType _convertPartyTaxScheme(@Nonnull TaxRegistrationType taxRegistrationType) {
        if (taxRegistrationType.getID() == null) {
            return null;
        }
        PartyTaxSchemeType partyTaxSchemeType = new PartyTaxSchemeType();
        partyTaxSchemeType.setCompanyID(taxRegistrationType.getIDValue());
        String string = taxRegistrationType.getID().getSchemeID();
        if (StringHelper.hasNoText(string)) {
            string = this.getVATScheme();
        } else if ("VA".equals(string)) {
            string = this.getVATScheme();
        }
        TaxSchemeType taxSchemeType = new TaxSchemeType();
        taxSchemeType.setID(string);
        partyTaxSchemeType.setTaxScheme(taxSchemeType);
        return partyTaxSchemeType;
    }

    @Nullable
    private static PartyLegalEntityType _convertPartyLegalEntity(@Nonnull TradePartyType tradePartyType) {
        PartyLegalEntityType partyLegalEntityType = new PartyLegalEntityType();
        LegalOrganizationType legalOrganizationType = tradePartyType.getSpecifiedLegalOrganization();
        if (legalOrganizationType != null) {
            if (StringHelper.hasText(legalOrganizationType.getTradingBusinessNameValue())) {
                partyLegalEntityType.setRegistrationName(legalOrganizationType.getTradingBusinessNameValue());
            }
            partyLegalEntityType.setCompanyID(CIIToUBL21Converter._copyID(legalOrganizationType.getID(), new CompanyIDType()));
        }
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : tradePartyType.getDescription()) {
            if (!StringHelper.hasText(textType.getValue())) continue;
            partyLegalEntityType.setCompanyLegalForm(textType.getValue());
            break;
        }
        if (partyLegalEntityType.getRegistrationName() == null) {
            partyLegalEntityType.setRegistrationName(tradePartyType.getNameValue());
        }
        return partyLegalEntityType;
    }

    @Nullable
    private static ContactType _convertContact(@Nonnull TradePartyType tradePartyType) {
        UniversalCommunicationType universalCommunicationType;
        UniversalCommunicationType universalCommunicationType2;
        if (!tradePartyType.hasDefinedTradeContactEntries()) {
            return null;
        }
        TradeContactType tradeContactType = tradePartyType.getDefinedTradeContactAtIndex(0);
        ContactType contactType = new ContactType();
        boolean bl = false;
        if (tradeContactType.getPersonName() != null) {
            contactType.setName(CIIToUBL21Converter._copyName(tradeContactType.getPersonName(), new NameType()));
            bl = true;
        }
        if ((universalCommunicationType2 = tradeContactType.getTelephoneUniversalCommunication()) != null) {
            contactType.setTelephone(universalCommunicationType2.getCompleteNumberValue());
            bl = true;
        }
        if ((universalCommunicationType = tradeContactType.getEmailURIUniversalCommunication()) != null) {
            contactType.setElectronicMail(universalCommunicationType.getURIIDValue());
            bl = true;
        }
        return bl ? contactType : null;
    }

    @Nullable
    private static AmountType _copyAmount(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType, @Nullable String string) {
        return CIIToUBL21Converter._copyAmount(amountType, new AmountType(), string);
    }

    private void _copyAllowanceCharge(@Nonnull TradeAllowanceChargeType tradeAllowanceChargeType, @Nonnull AllowanceChargeType allowanceChargeType, @Nullable String string) {
        if (StringHelper.hasText(tradeAllowanceChargeType.getReasonCodeValue())) {
            allowanceChargeType.setAllowanceChargeReasonCode(tradeAllowanceChargeType.getReasonCodeValue());
        }
        if (tradeAllowanceChargeType.getReason() != null) {
            AllowanceChargeReasonType allowanceChargeReasonType = new AllowanceChargeReasonType();
            allowanceChargeReasonType.setValue(tradeAllowanceChargeType.getReasonValue());
            allowanceChargeType.addAllowanceChargeReason(allowanceChargeReasonType);
        }
        if (tradeAllowanceChargeType.getCalculationPercent() != null) {
            allowanceChargeType.setMultiplierFactorNumeric(tradeAllowanceChargeType.getCalculationPercentValue().divide(CGlobal.BIGDEC_100));
        }
        if (tradeAllowanceChargeType.hasActualAmountEntries()) {
            allowanceChargeType.setAmount(CIIToUBL21Converter._copyAmount(tradeAllowanceChargeType.getActualAmountAtIndex(0), string));
        }
        allowanceChargeType.setBaseAmount(CIIToUBL21Converter._copyAmount(tradeAllowanceChargeType.getBasisAmount(), new BaseAmountType(), string));
        for (TradeTaxType tradeTaxType : tradeAllowanceChargeType.getCategoryTradeTax()) {
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType.getCategoryCodeValue());
            if (tradeTaxType.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(tradeTaxType.getRateApplicablePercentValue());
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            allowanceChargeType.addTaxCategory(taxCategoryType);
        }
    }

    private void _convertPaymentMeans(@Nonnull HeaderTradeSettlementType headerTradeSettlementType, @Nonnull TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType, @Nonnull Consumer<oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType> consumer, @Nonnull Consumer<PaymentMeansType> consumer2, @Nonnull ErrorList errorList) {
        boolean bl;
        boolean bl2;
        Object object;
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        String string = tradeSettlementPaymentMeansType.getTypeCodeValue();
        PaymentMeansType paymentMeansType = new PaymentMeansType();
        PaymentMeansCodeType paymentMeansCodeType = new PaymentMeansCodeType();
        paymentMeansCodeType.setValue(string);
        if (tradeSettlementPaymentMeansType.hasInformationEntries()) {
            paymentMeansCodeType.setName(tradeSettlementPaymentMeansType.getInformationAtIndex(0).getValue());
        }
        paymentMeansType.setPaymentMeansCode(paymentMeansCodeType);
        for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType iExplicitlyCloneable3 : headerTradeSettlementType.getPaymentReference()) {
            iExplicitlyCloneable2 = new PaymentIDType();
            ((IdentifierType)iExplicitlyCloneable2).setValue(iExplicitlyCloneable3.getValue());
            paymentMeansType.addPaymentID((PaymentIDType)iExplicitlyCloneable2);
        }
        boolean bl3 = CIIToUBL21Converter.isPaymentMeansCodeCreditTransfer(string);
        if (bl3) {
            CreditorFinancialAccountType bl22 = tradeSettlementPaymentMeansType.getPayeePartyCreditorFinancialAccount();
            if (bl22 == null) {
                errorList.add(CIIToUBL21Converter._buildError(null, "The element 'PayeePartyCreditorFinancialAccount' is missing for Credit Transfer"));
            } else {
                iExplicitlyCloneable2 = new FinancialAccountType();
                ((FinancialAccountType)iExplicitlyCloneable2).setID(CIIToUBL21Converter._copyID(bl22.getIBANID()));
                if (((FinancialAccountType)iExplicitlyCloneable2).getID() == null) {
                    ((FinancialAccountType)iExplicitlyCloneable2).setID(CIIToUBL21Converter._copyID(bl22.getProprietaryID()));
                }
                ((FinancialAccountType)iExplicitlyCloneable2).setName(CIIToUBL21Converter._copyName(bl22.getAccountName(), new NameType()));
                iExplicitlyCloneable = tradeSettlementPaymentMeansType.getPayeeSpecifiedCreditorFinancialInstitution();
                if (iExplicitlyCloneable != null) {
                    object = new BranchType();
                    ((BranchType)object).setID(CIIToUBL21Converter._copyID(((CreditorFinancialInstitutionType)iExplicitlyCloneable).getBICID()));
                    ((FinancialAccountType)iExplicitlyCloneable2).setFinancialInstitutionBranch((BranchType)object);
                }
                paymentMeansType.setPayeeFinancialAccount((FinancialAccountType)iExplicitlyCloneable2);
            }
        }
        if (bl2 = CIIToUBL21Converter.isPaymentMeansCodePaymentCard(string)) {
            iExplicitlyCloneable2 = tradeSettlementPaymentMeansType.getApplicableTradeSettlementFinancialCard();
            if (iExplicitlyCloneable2 == null) {
                errorList.add(CIIToUBL21Converter._buildError(null, "The element 'ApplicableTradeSettlementFinancialCard' is missing for Payment Card Information"));
            } else {
                iExplicitlyCloneable = new CardAccountType();
                ((CardAccountType)iExplicitlyCloneable).setPrimaryAccountNumberID(CIIToUBL21Converter._copyID(((TradeSettlementFinancialCardType)iExplicitlyCloneable2).getID(), new PrimaryAccountNumberIDType()));
                ((CardAccountType)iExplicitlyCloneable).setNetworkID(this.getCardAccountNetworkID());
                ((CardAccountType)iExplicitlyCloneable).setHolderName(((TradeSettlementFinancialCardType)iExplicitlyCloneable2).getCardholderNameValue());
                if (StringHelper.hasNoText(((CardAccountType)iExplicitlyCloneable).getPrimaryAccountNumberIDValue())) {
                    errorList.add(CIIToUBL21Converter._buildError(null, "The Payment card primary account number is missing"));
                } else if (StringHelper.hasNoText(((CardAccountType)iExplicitlyCloneable).getNetworkIDValue())) {
                    errorList.add(CIIToUBL21Converter._buildError(null, "The Payment card network ID is missing"));
                } else {
                    paymentMeansType.setCardAccount((CardAccountType)iExplicitlyCloneable);
                }
            }
        }
        if (bl = CIIToUBL21Converter.isPaymentMeansCodeDirectDebit(string)) {
            IExplicitlyCloneable iExplicitlyCloneable3;
            iExplicitlyCloneable = new PaymentMandateType();
            object = headerTradeSettlementType.getSpecifiedTradePaymentTerms().iterator();
            while (object.hasNext()) {
                iExplicitlyCloneable3 = object.next();
                if (!((TradePaymentTermsType)iExplicitlyCloneable3).hasDirectDebitMandateIDEntries()) continue;
                ((PaymentMandateType)iExplicitlyCloneable).setID(CIIToUBL21Converter._copyID(((TradePaymentTermsType)iExplicitlyCloneable3).getDirectDebitMandateIDAtIndex(0)));
                if (((PaymentMandateType)iExplicitlyCloneable).getID() == null) continue;
                break;
            }
            if ((object = headerTradeSettlementType.getCreditorReferenceID()) != null) {
                iExplicitlyCloneable3 = CIIToUBL21Converter._copyID((IDType)object);
                ((IdentifierType)iExplicitlyCloneable3).setSchemeID("SEPA");
                consumer.accept((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType)iExplicitlyCloneable3);
            }
            if ((iExplicitlyCloneable3 = tradeSettlementPaymentMeansType.getPayerPartyDebtorFinancialAccount()) != null) {
                FinancialAccountType financialAccountType = new FinancialAccountType();
                financialAccountType.setID(CIIToUBL21Converter._copyID(((DebtorFinancialAccountType)iExplicitlyCloneable3).getIBANID()));
                if (financialAccountType.getID() != null) {
                    ((PaymentMandateType)iExplicitlyCloneable).setPayerFinancialAccount(financialAccountType);
                }
            }
            paymentMeansType.setPaymentMandate((PaymentMandateType)iExplicitlyCloneable);
        }
        if (bl3 || bl2 || bl || CIIToUBL21Converter.isPaymentMeansCodeOtherKnown(string)) {
            consumer2.accept(paymentMeansType);
        } else {
            errorList.add(CIIToUBL21Converter._buildError(null, "Failed to determine a supported Payment Means Type from code '" + string + "'"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public InvoiceType convertToInvoice(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        boolean bl;
        Object object;
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        IExplicitlyCloneable iExplicitlyCloneable3;
        TradePartyType tradePartyType;
        DateTimeType dateTimeType;
        TradePartyType tradePartyType2;
        TradePartyType tradePartyType3;
        TradePartyType tradePartyType4;
        Object object2;
        TradePartyType tradePartyType5;
        String string;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType2;
        DocumentReferenceType documentReferenceType3;
        ReferencedDocumentType referencedDocumentType;
        SpecifiedPeriodType specifiedPeriodType;
        ValueEnforcer.notNull(crossIndustryInvoiceType, "CIIInvoice");
        ValueEnforcer.notNull(errorList, "ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setCustomizationID(this.getCustomizationID());
        invoiceType.setProfileID(this.getProfileID());
        if (exchangedDocumentType != null) {
            invoiceType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        invoiceType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        invoiceType.setAccountingCustomerParty(customerPartyType);
        Object object6 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object6 = CIIToUBL21Converter._parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object6 != null) {
            invoiceType.setIssueDate((LocalDate)object6);
        }
        object6 = null;
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            if (tradePaymentTermsType.getDueDateDateTime() != null && (object6 = CIIToUBL21Converter._parseDate(tradePaymentTermsType.getDueDateDateTime().getDateTimeString(), (IErrorList)errorList)) != null) break;
        }
        if (object6 != null) {
            invoiceType.setDueDate((LocalDate)object6);
        }
        if (exchangedDocumentType != null) {
            invoiceType.setInvoiceTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (NoteType noteType : exchangedDocumentType.getIncludedNote()) {
                invoiceType.addNote(CIIToUBL21Converter._copyNote(noteType));
            }
        }
        for (TradeTaxType tradeTaxType : headerTradeSettlementType.getApplicableTradeTax()) {
            LocalDate localDate;
            if (tradeTaxType.getTaxPointDate() == null || (localDate = CIIToUBL21Converter._parseDate(tradeTaxType.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            invoiceType.setTaxPointDate(localDate);
            break;
        }
        object6 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        invoiceType.setDocumentCurrencyCode((String)object6);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            invoiceType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        for (TradeAccountingAccountType tradeAccountingAccountType : headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount()) {
            String string2 = tradeAccountingAccountType.getIDValue();
            if (!StringHelper.hasText(string2)) continue;
            invoiceType.setAccountingCost(string2);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            invoiceType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        if ((specifiedPeriodType = headerTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
            DateTimeType dateTimeType2 = specifiedPeriodType.getStartDateTime();
            DateTimeType dateTimeType3 = specifiedPeriodType.getEndDateTime();
            if (dateTimeType2 != null && dateTimeType3 != null) {
                PeriodType periodType = new PeriodType();
                periodType.setStartDate(CIIToUBL21Converter._parseDate(dateTimeType2.getDateTimeString(), (IErrorList)errorList));
                periodType.setEndDate(CIIToUBL21Converter._parseDate(dateTimeType3.getDateTimeString(), (IErrorList)errorList));
                invoiceType.addInvoicePeriod(periodType);
            }
        }
        OrderReferenceType orderReferenceType = new OrderReferenceType();
        ReferencedDocumentType referencedDocumentType2 = headerTradeAgreementType.getBuyerOrderReferencedDocument();
        if (referencedDocumentType2 != null) {
            orderReferenceType.setID(referencedDocumentType2.getIssuerAssignedIDValue());
        }
        if ((referencedDocumentType = headerTradeAgreementType.getSellerOrderReferencedDocument()) != null) {
            if (orderReferenceType.getIDValue() == null) {
                orderReferenceType.setID("");
            }
            orderReferenceType.setSalesOrderID(referencedDocumentType.getIssuerAssignedIDValue());
        }
        if (orderReferenceType.getIDValue() != null || orderReferenceType.getSalesOrderIDValue() != null) {
            invoiceType.setOrderReference(orderReferenceType);
        }
        if ((documentReferenceType3 = CIIToUBL21Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), errorList)) != null) {
            BillingReferenceType billingReferenceType = new BillingReferenceType();
            billingReferenceType.setInvoiceDocumentReference(documentReferenceType3);
            invoiceType.addBillingReference(billingReferenceType);
        }
        if ((documentReferenceType2 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), errorList)) != null) {
            invoiceType.addDespatchDocumentReference(documentReferenceType2);
        }
        if ((documentReferenceType = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), errorList)) != null) {
            invoiceType.addReceiptDocumentReference(documentReferenceType);
        }
        for (ReferencedDocumentType referencedDocumentType3 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType4;
            if (!CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType3.getTypeCodeValue()) || (documentReferenceType4 = CIIToUBL21Converter._convertDocumentReference(referencedDocumentType3, errorList)) == null) continue;
            invoiceType.addOriginatorDocumentReference(documentReferenceType4);
        }
        DocumentReferenceType documentReferenceType5 = CIIToUBL21Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), errorList);
        if (documentReferenceType5 != null) {
            invoiceType.addContractDocumentReference(documentReferenceType5);
        }
        for (ReferencedDocumentType referencedDocumentType4 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType6;
            if (CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType4.getTypeCodeValue()) || (documentReferenceType6 = CIIToUBL21Converter._convertDocumentReference(referencedDocumentType4, errorList)) == null) continue;
            invoiceType.addAdditionalDocumentReference(documentReferenceType6);
        }
        ProcuringProjectType procuringProjectType = headerTradeAgreementType.getSpecifiedProcuringProject();
        if (procuringProjectType != null && StringHelper.hasText(string = procuringProjectType.getIDValue())) {
            ProjectReferenceType projectReferenceType = new ProjectReferenceType();
            projectReferenceType.setID(string);
            invoiceType.addProjectReference(projectReferenceType);
        }
        if ((tradePartyType5 = headerTradeAgreementType.getSellerTradeParty()) != null) {
            ContactType contactType;
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType5);
            for (TaxRegistrationType taxRegistrationType : tradePartyType5.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme(taxRegistrationType);
                if (object2 == null) continue;
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            PartyLegalEntityType partyLegalEntityType = CIIToUBL21Converter._convertPartyLegalEntity(tradePartyType5);
            if (partyLegalEntityType != null) {
                partyType.addPartyLegalEntity(partyLegalEntityType);
            }
            if ((contactType = CIIToUBL21Converter._convertContact(tradePartyType5)) != null) {
                partyType.setContact(contactType);
            }
            supplierPartyType.setParty(partyType);
        }
        if ((tradePartyType4 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            ContactType contactType;
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType4);
            for (TaxRegistrationType taxRegistrationType : tradePartyType4.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme(taxRegistrationType);
                if (object2 == null) continue;
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            PartyLegalEntityType partyLegalEntityType = CIIToUBL21Converter._convertPartyLegalEntity(tradePartyType4);
            if (partyLegalEntityType != null) {
                partyType.addPartyLegalEntity(partyLegalEntityType);
            }
            if ((contactType = CIIToUBL21Converter._convertContact(tradePartyType4)) != null) {
                partyType.setContact(contactType);
            }
            customerPartyType.setParty(partyType);
        }
        if ((tradePartyType3 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType3);
            for (TaxRegistrationType taxRegistrationType : tradePartyType3.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme(taxRegistrationType);
                if (object2 == null) continue;
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            ContactType contactType = CIIToUBL21Converter._convertContact(tradePartyType3);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            invoiceType.setPayeeParty(partyType);
        }
        if ((tradePartyType2 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType2);
            for (TaxRegistrationType taxRegistrationType : tradePartyType2.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme(taxRegistrationType);
                if (object2 == null) continue;
                partyType.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            ContactType contactType = CIIToUBL21Converter._convertContact(tradePartyType2);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            invoiceType.setTaxRepresentativeParty(partyType);
        }
        DeliveryType deliveryType = new DeliveryType();
        boolean bl2 = false;
        SupplyChainEventType supplyChainEventType = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
        if (supplyChainEventType != null && (dateTimeType = supplyChainEventType.getOccurrenceDateTime()) != null) {
            deliveryType.setActualDeliveryDate(CIIToUBL21Converter._parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
            boolean bl3 = true;
        }
        if ((tradePartyType = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            object2 = new LocationType();
            boolean bl4 = false;
            oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType2 = CIIToUBL21Converter._extractPartyID(tradePartyType);
            if (iDType2 != null) {
                ((LocationType)object2).setID(iDType2);
                bl4 = true;
            }
            if ((iExplicitlyCloneable3 = tradePartyType.getPostalTradeAddress()) != null) {
                ((LocationType)object2).setAddress(CIIToUBL21Converter._convertPostalAddress((TradeAddressType)iExplicitlyCloneable3));
                bl4 = true;
            }
            if (bl4) {
                deliveryType.setDeliveryLocation((LocationType)object2);
                boolean bl5 = true;
            }
            if ((iExplicitlyCloneable2 = tradePartyType.getName()) != null) {
                iExplicitlyCloneable = new PartyType();
                object = new PartyNameType();
                ((PartyNameType)object).setName(CIIToUBL21Converter._copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable2, new NameType()));
                ((PartyType)iExplicitlyCloneable).addPartyName((PartyNameType)object);
                deliveryType.setDeliveryParty((PartyType)iExplicitlyCloneable);
                bl = true;
            }
        }
        if (bl) {
            invoiceType.addDelivery(deliveryType);
        }
        for (TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, tradeSettlementPaymentMeansType, iDType -> CIIToUBL21Converter._addPartyID(iDType, invoiceType.getAccountingSupplierParty().getParty()), invoiceType::addPaymentMeans, errorList);
        }
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            boolean bl6;
            boolean bl7 = false;
            PaymentTermsType paymentTermsType = new PaymentTermsType();
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : tradePaymentTermsType.getDescription()) {
                paymentTermsType.addNote(CIIToUBL21Converter._copyNote(textType));
                bl6 = true;
            }
            if (!bl6) continue;
            invoiceType.addPaymentTerms(paymentTermsType);
        }
        for (TradeAllowanceChargeType tradeAllowanceChargeType : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            void var14_101;
            ETriState eTriState = ETriState.UNDEFINED;
            if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                ETriState eTriState2 = CIIToUBL21Converter._parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
            } else {
                errorList.add(CIIToUBL21Converter._buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!var14_101.isDefined()) continue;
            AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
            allowanceChargeType.setChargeIndicator(var14_101.getAsBooleanValue());
            this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object6);
            invoiceType.addAllowanceCharge(allowanceChargeType);
        }
        TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        Object var13_67 = null;
        if (tradeSettlementHeaderMonetarySummationType != null && tradeSettlementHeaderMonetarySummationType.hasTaxTotalAmountEntries()) {
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType : tradeSettlementHeaderMonetarySummationType.getTaxTotalAmount()) {
                void var13_68;
                object2 = new TaxTotalType();
                ((TaxTotalType)object2).setTaxAmount(CIIToUBL21Converter._copyAmount(amountType, new TaxAmountType(), (String)object6));
                invoiceType.addTaxTotal((TaxTotalType)object2);
                if (var13_68 != null) continue;
                Object object3 = object2;
            }
        } else {
            TaxAmountType taxAmountType = new TaxAmountType();
            taxAmountType.setValue(BigDecimal.ZERO);
            taxAmountType.setCurrencyID((String)object6);
            TaxTotalType taxTotalType = new TaxTotalType();
            taxTotalType.setTaxAmount(taxAmountType);
            invoiceType.addTaxTotal(taxTotalType);
        }
        for (TradeTaxType tradeTaxType : headerTradeSettlementType.getApplicableTradeTax()) {
            void var13_71;
            object2 = new TaxSubtotalType();
            if (tradeTaxType.hasBasisAmountEntries()) {
                ((TaxSubtotalType)object2).setTaxableAmount(CIIToUBL21Converter._copyAmount(tradeTaxType.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object6));
            }
            if (tradeTaxType.hasCalculatedAmountEntries()) {
                ((TaxSubtotalType)object2).setTaxAmount(CIIToUBL21Converter._copyAmount(tradeTaxType.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object6));
            }
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType.getCategoryCodeValue());
            if (tradeTaxType.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(tradeTaxType.getRateApplicablePercentValue());
            }
            if (StringHelper.hasText(tradeTaxType.getExemptionReasonCodeValue())) {
                taxCategoryType.setTaxExemptionReasonCode(tradeTaxType.getExemptionReasonCodeValue());
            }
            if (tradeTaxType.getExemptionReason() != null) {
                TaxExemptionReasonType taxExemptionReasonType = new TaxExemptionReasonType();
                taxExemptionReasonType.setValue(tradeTaxType.getExemptionReason().getValue());
                taxExemptionReasonType.setLanguageID(tradeTaxType.getExemptionReason().getLanguageID());
                taxExemptionReasonType.setLanguageLocaleID(tradeTaxType.getExemptionReason().getLanguageLocaleID());
                taxCategoryType.addTaxExemptionReason(taxExemptionReasonType);
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            ((TaxSubtotalType)object2).setTaxCategory(taxCategoryType);
            var13_71.addTaxSubtotal((TaxSubtotalType)object2);
        }
        MonetaryTotalType monetaryTotalType = new MonetaryTotalType();
        if (tradeSettlementHeaderMonetarySummationType != null) {
            if (tradeSettlementHeaderMonetarySummationType.hasLineTotalAmountEntries()) {
                monetaryTotalType.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTaxBasisTotalAmountEntries()) {
                monetaryTotalType.setTaxExclusiveAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasGrandTotalAmountEntries()) {
                monetaryTotalType.setTaxInclusiveAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasAllowanceTotalAmountEntries()) {
                monetaryTotalType.setAllowanceTotalAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasChargeTotalAmountEntries()) {
                monetaryTotalType.setChargeTotalAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTotalPrepaidAmountEntries()) {
                monetaryTotalType.setPrepaidAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasRoundingAmountEntries() && MathHelper.isNE0(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0).getValue())) {
                monetaryTotalType.setPayableRoundingAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object6));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasDuePayableAmountEntries()) {
                monetaryTotalType.setPayableAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object6));
            }
        }
        invoiceType.setLegalMonetaryTotal(monetaryTotalType);
        for (SupplyChainTradeLineItemType supplyChainTradeLineItemType : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            boolean bl8;
            Object object4;
            IExplicitlyCloneable iExplicitlyCloneable4;
            Object object5;
            IExplicitlyCloneable iExplicitlyCloneable5;
            Object object7;
            LineTradeSettlementType lineTradeSettlementType;
            QuantityType quantityType;
            InvoiceLineType invoiceLineType = new InvoiceLineType();
            object2 = supplyChainTradeLineItemType.getAssociatedDocumentLineDocument();
            invoiceLineType.setID(CIIToUBL21Converter._copyID(((DocumentLineDocumentType)object2).getLineID()));
            for (NoteType noteType : ((DocumentLineDocumentType)object2).getIncludedNote()) {
                invoiceLineType.addNote(CIIToUBL21Converter._copyNote(noteType));
            }
            LineTradeDeliveryType lineTradeDeliveryType = supplyChainTradeLineItemType.getSpecifiedLineTradeDelivery();
            if (lineTradeDeliveryType != null && (quantityType = lineTradeDeliveryType.getBilledQuantity()) != null) {
                invoiceLineType.setInvoicedQuantity(CIIToUBL21Converter._copyQuantity(quantityType, new InvoicedQuantityType()));
            }
            if ((iExplicitlyCloneable3 = (lineTradeSettlementType = supplyChainTradeLineItemType.getSpecifiedLineTradeSettlement()).getSpecifiedTradeSettlementLineMonetarySummation()) != null && ((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable3).hasLineTotalAmountEntries()) {
                invoiceLineType.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable3).getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object6));
            }
            if (lineTradeSettlementType.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                iExplicitlyCloneable2 = lineTradeSettlementType.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                invoiceLineType.setAccountingCost(((TradeAccountingAccountType)iExplicitlyCloneable2).getIDValue());
            }
            if ((iExplicitlyCloneable2 = lineTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
                iExplicitlyCloneable = new PeriodType();
                if (((SpecifiedPeriodType)iExplicitlyCloneable2).getStartDateTime() != null) {
                    ((PeriodType)iExplicitlyCloneable).setStartDate(CIIToUBL21Converter._parseDate(((SpecifiedPeriodType)iExplicitlyCloneable2).getStartDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                if (((SpecifiedPeriodType)iExplicitlyCloneable2).getEndDateTime() != null) {
                    ((PeriodType)iExplicitlyCloneable).setEndDate(CIIToUBL21Converter._parseDate(((SpecifiedPeriodType)iExplicitlyCloneable2).getEndDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                invoiceLineType.addInvoicePeriod((PeriodType)iExplicitlyCloneable);
            }
            if ((iExplicitlyCloneable = supplyChainTradeLineItemType.getSpecifiedLineTradeAgreement()) != null && (object = ((LineTradeAgreementType)iExplicitlyCloneable).getBuyerOrderReferencedDocument()) != null) {
                OrderLineReferenceType orderLineReferenceType = new OrderLineReferenceType();
                orderLineReferenceType.setLineID(CIIToUBL21Converter._copyID(((ReferencedDocumentType)object).getLineID(), new LineIDType()));
                invoiceLineType.addOrderLineReference(orderLineReferenceType);
            }
            for (ReferencedDocumentType referencedDocumentType5 : lineTradeSettlementType.getAdditionalReferencedDocument()) {
                object7 = CIIToUBL21Converter._convertDocumentReference(referencedDocumentType5, errorList);
                if (object7 == null) continue;
                invoiceLineType.addDocumentReference((DocumentReferenceType)object7);
            }
            for (TradeAllowanceChargeType tradeAllowanceChargeType : lineTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
                object7 = ETriState.UNDEFINED;
                if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                    object7 = CIIToUBL21Converter._parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
                } else {
                    errorList.add(CIIToUBL21Converter._buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!((ETriState)object7).isDefined()) continue;
                AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                allowanceChargeType.setChargeIndicator(((ETriState)object7).getAsBooleanValue());
                this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object6);
                invoiceLineType.addAllowanceCharge(allowanceChargeType);
            }
            object = new ItemType();
            TradeProductType tradeProductType = supplyChainTradeLineItemType.getSpecifiedTradeProduct();
            if (tradeProductType != null) {
                IDType iDType3;
                object7 = tradeProductType.getDescription();
                if (object7 != null) {
                    ((ItemType)object).addDescription(CIIToUBL21Converter._copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)object7, new DescriptionType()));
                }
                if (tradeProductType.hasNameEntries()) {
                    ((ItemType)object).setName(CIIToUBL21Converter._copyName(tradeProductType.getNameAtIndex(0), new NameType()));
                }
                if ((iDType3 = tradeProductType.getBuyerAssignedID()) != null) {
                    iExplicitlyCloneable5 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable5).setID(CIIToUBL21Converter._copyID(iDType3));
                    ((ItemType)object).setBuyersItemIdentification((ItemIdentificationType)iExplicitlyCloneable5);
                }
                if ((iExplicitlyCloneable5 = tradeProductType.getSellerAssignedID()) != null) {
                    object5 = new ItemIdentificationType();
                    ((ItemIdentificationType)object5).setID(CIIToUBL21Converter._copyID((IDType)iExplicitlyCloneable5));
                    ((ItemType)object).setSellersItemIdentification((ItemIdentificationType)object5);
                }
                if ((object5 = tradeProductType.getGlobalID()) != null) {
                    iExplicitlyCloneable4 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable4).setID(CIIToUBL21Converter._copyID((IDType)object5));
                    ((ItemType)object).setStandardItemIdentification((ItemIdentificationType)iExplicitlyCloneable4);
                }
                if ((iExplicitlyCloneable4 = tradeProductType.getOriginTradeCountry()) != null) {
                    object4 = new CountryType();
                    ((CountryType)object4).setIdentificationCode(((TradeCountryType)iExplicitlyCloneable4).getIDValue());
                    if (((TradeCountryType)iExplicitlyCloneable4).hasNameEntries()) {
                        ((CountryType)object4).setName(CIIToUBL21Converter._copyName(((TradeCountryType)iExplicitlyCloneable4).getNameAtIndex(0), new NameType()));
                    }
                    ((ItemType)object).setOriginCountry((CountryType)object4);
                }
                for (ProductClassificationType productClassificationType : tradeProductType.getDesignatedProductClassification()) {
                    CodeType codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL21Converter._copyCode(codeType, new ItemClassificationCodeType()));
                    ((ItemType)object).addCommodityClassification(commodityClassificationType);
                }
            }
            for (TradeTaxType tradeTaxType : lineTradeSettlementType.getApplicableTradeTax()) {
                iExplicitlyCloneable5 = new TaxCategoryType();
                ((TaxCategoryType)iExplicitlyCloneable5).setID(tradeTaxType.getCategoryCodeValue());
                if (tradeTaxType.getRateApplicablePercentValue() != null) {
                    ((TaxCategoryType)iExplicitlyCloneable5).setPercent(tradeTaxType.getRateApplicablePercentValue());
                }
                object5 = new TaxSchemeType();
                ((TaxSchemeType)object5).setID(this.getVATScheme());
                ((TaxCategoryType)iExplicitlyCloneable5).setTaxScheme((TaxSchemeType)object5);
                ((ItemType)object).addClassifiedTaxCategory((TaxCategoryType)iExplicitlyCloneable5);
            }
            if (tradeProductType != null) {
                for (ProductCharacteristicType productCharacteristicType : tradeProductType.getApplicableProductCharacteristic()) {
                    if (!productCharacteristicType.hasDescriptionEntries()) continue;
                    iExplicitlyCloneable5 = new ItemPropertyType();
                    ((ItemPropertyType)iExplicitlyCloneable5).setName(CIIToUBL21Converter._copyName(productCharacteristicType.getDescriptionAtIndex(0), new NameType()));
                    if (productCharacteristicType.hasValueEntries()) {
                        ((ItemPropertyType)iExplicitlyCloneable5).setValue(productCharacteristicType.getValueAtIndex(0).getValue());
                    }
                    ((ItemType)object).addAdditionalItemProperty((ItemPropertyType)iExplicitlyCloneable5);
                }
            }
            object7 = new PriceType();
            boolean bl9 = false;
            if (iExplicitlyCloneable != null && (iExplicitlyCloneable5 = ((LineTradeAgreementType)iExplicitlyCloneable).getNetPriceProductTradePrice()) != null) {
                if (((TradePriceType)iExplicitlyCloneable5).hasChargeAmountEntries()) {
                    ((PriceType)object7).setPriceAmount(CIIToUBL21Converter._copyAmount(((TradePriceType)iExplicitlyCloneable5).getChargeAmountAtIndex(0), new PriceAmountType(), (String)object6));
                    boolean bl10 = true;
                }
                if (((TradePriceType)iExplicitlyCloneable5).getBasisQuantity() != null) {
                    ((PriceType)object7).setBaseQuantity(CIIToUBL21Converter._copyQuantity(((TradePriceType)iExplicitlyCloneable5).getBasisQuantity(), new BaseQuantityType()));
                    bl8 = true;
                }
            }
            if ((iExplicitlyCloneable5 = ((LineTradeAgreementType)iExplicitlyCloneable).getNetPriceProductTradePrice()) != null) {
                object5 = ((TradePriceType)iExplicitlyCloneable5).getAppliedTradeAllowanceCharge().iterator();
                while (object5.hasNext()) {
                    iExplicitlyCloneable4 = (TradeAllowanceChargeType)object5.next();
                    object4 = ETriState.UNDEFINED;
                    if (((TradeAllowanceChargeType)iExplicitlyCloneable4).getChargeIndicator() != null) {
                        object4 = CIIToUBL21Converter._parseIndicator(((TradeAllowanceChargeType)iExplicitlyCloneable4).getChargeIndicator(), errorList);
                    } else {
                        errorList.add(CIIToUBL21Converter._buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeAgreement", "NetPriceProductTradePrice", "AppliedTradeAllowanceCharge"}, "Failed to determine if AppliedTradeAllowanceCharge is an Allowance or a Charge"));
                    }
                    if (!((ETriState)object4).isDefined()) continue;
                    AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                    allowanceChargeType.setChargeIndicator(((ETriState)object4).getAsBooleanValue());
                    this._copyAllowanceCharge((TradeAllowanceChargeType)iExplicitlyCloneable4, allowanceChargeType, (String)object6);
                    ((PriceType)object7).addAllowanceCharge(allowanceChargeType);
                }
            }
            if (bl8) {
                invoiceLineType.setPrice((PriceType)object7);
            }
            invoiceLineType.setItem((ItemType)object);
            invoiceType.addInvoiceLine(invoiceLineType);
        }
        return invoiceType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CreditNoteType convertToCreditNote(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        IExplicitlyCloneable iExplicitlyCloneable;
        IExplicitlyCloneable iExplicitlyCloneable2;
        IExplicitlyCloneable iExplicitlyCloneable3;
        TradePartyType tradePartyType;
        TradePartyType tradePartyType2;
        TradePartyType tradePartyType3;
        TradePartyType tradePartyType4;
        PartyTaxSchemeType partyTaxSchemeType;
        DocumentReferenceType documentReferenceType;
        DocumentReferenceType documentReferenceType2;
        DocumentReferenceType documentReferenceType3;
        ReferencedDocumentType referencedDocumentType;
        SpecifiedPeriodType specifiedPeriodType;
        ValueEnforcer.notNull(crossIndustryInvoiceType, "CIICreditNote");
        ValueEnforcer.notNull(errorList, "ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        CreditNoteType creditNoteType = new CreditNoteType();
        creditNoteType.setCustomizationID(this.getCustomizationID());
        creditNoteType.setProfileID(this.getProfileID());
        if (exchangedDocumentType != null) {
            creditNoteType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        creditNoteType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        creditNoteType.setAccountingCustomerParty(customerPartyType);
        Object object5 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object5 = CIIToUBL21Converter._parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object5 != null) {
            creditNoteType.setIssueDate((LocalDate)object5);
        }
        if (exchangedDocumentType != null) {
            creditNoteType.setCreditNoteTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (NoteType object42 : exchangedDocumentType.getIncludedNote()) {
                creditNoteType.addNote(CIIToUBL21Converter._copyNote(object42));
            }
        }
        for (TradeTaxType tradeTaxType : headerTradeSettlementType.getApplicableTradeTax()) {
            LocalDate localDate;
            if (tradeTaxType.getTaxPointDate() == null || (localDate = CIIToUBL21Converter._parseDate(tradeTaxType.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            creditNoteType.setTaxPointDate(localDate);
            break;
        }
        object5 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        creditNoteType.setDocumentCurrencyCode((String)object5);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            creditNoteType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        for (TradeAccountingAccountType tradeAccountingAccountType : headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount()) {
            String string = tradeAccountingAccountType.getIDValue();
            if (!StringHelper.hasText(string)) continue;
            creditNoteType.setAccountingCost(string);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            creditNoteType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        if ((specifiedPeriodType = headerTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
            DateTimeType dateTimeType = specifiedPeriodType.getStartDateTime();
            DateTimeType dateTimeType2 = specifiedPeriodType.getEndDateTime();
            if (dateTimeType != null && dateTimeType2 != null) {
                PeriodType periodType = new PeriodType();
                periodType.setStartDate(CIIToUBL21Converter._parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
                periodType.setEndDate(CIIToUBL21Converter._parseDate(dateTimeType2.getDateTimeString(), (IErrorList)errorList));
                creditNoteType.addInvoicePeriod(periodType);
            }
        }
        OrderReferenceType orderReferenceType = new OrderReferenceType();
        ReferencedDocumentType referencedDocumentType2 = headerTradeAgreementType.getBuyerOrderReferencedDocument();
        if (referencedDocumentType2 != null) {
            orderReferenceType.setID(referencedDocumentType2.getIssuerAssignedIDValue());
        }
        if ((referencedDocumentType = headerTradeAgreementType.getSellerOrderReferencedDocument()) != null) {
            if (orderReferenceType.getIDValue() == null) {
                orderReferenceType.setID("");
            }
            orderReferenceType.setSalesOrderID(referencedDocumentType.getIssuerAssignedIDValue());
        }
        if (orderReferenceType.getIDValue() != null || orderReferenceType.getSalesOrderIDValue() != null) {
            creditNoteType.setOrderReference(orderReferenceType);
        }
        if ((documentReferenceType3 = CIIToUBL21Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), errorList)) != null) {
            BillingReferenceType billingReferenceType = new BillingReferenceType();
            billingReferenceType.setCreditNoteDocumentReference(documentReferenceType3);
            creditNoteType.addBillingReference(billingReferenceType);
        }
        if ((documentReferenceType2 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), errorList)) != null) {
            creditNoteType.addDespatchDocumentReference(documentReferenceType2);
        }
        if ((documentReferenceType = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), errorList)) != null) {
            creditNoteType.addReceiptDocumentReference(documentReferenceType);
        }
        for (ReferencedDocumentType referencedDocumentType3 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType4;
            if (!CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType3.getTypeCodeValue()) || (documentReferenceType4 = CIIToUBL21Converter._convertDocumentReference(referencedDocumentType3, errorList)) == null) continue;
            creditNoteType.addOriginatorDocumentReference(documentReferenceType4);
        }
        DocumentReferenceType documentReferenceType5 = CIIToUBL21Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), errorList);
        if (documentReferenceType5 != null) {
            creditNoteType.addContractDocumentReference(documentReferenceType5);
        }
        for (ReferencedDocumentType referencedDocumentType4 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            DocumentReferenceType documentReferenceType6;
            if (CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(referencedDocumentType4.getTypeCodeValue()) || (documentReferenceType6 = CIIToUBL21Converter._convertDocumentReference(referencedDocumentType4, errorList)) == null) continue;
            creditNoteType.addAdditionalDocumentReference(documentReferenceType6);
        }
        TradePartyType tradePartyType5 = headerTradeAgreementType.getSellerTradeParty();
        if (tradePartyType5 != null) {
            ContactType contactType;
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType5);
            for (TaxRegistrationType taxRegistrationType : tradePartyType5.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            PartyLegalEntityType partyLegalEntityType = CIIToUBL21Converter._convertPartyLegalEntity(tradePartyType5);
            if (partyLegalEntityType != null) {
                partyType.addPartyLegalEntity(partyLegalEntityType);
            }
            if ((contactType = CIIToUBL21Converter._convertContact(tradePartyType5)) != null) {
                partyType.setContact(contactType);
            }
            supplierPartyType.setParty(partyType);
        }
        if ((tradePartyType4 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            ContactType contactType;
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType4);
            for (TaxRegistrationType taxRegistrationType : tradePartyType4.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            PartyLegalEntityType partyLegalEntityType = CIIToUBL21Converter._convertPartyLegalEntity(tradePartyType4);
            if (partyLegalEntityType != null) {
                partyType.addPartyLegalEntity(partyLegalEntityType);
            }
            if ((contactType = CIIToUBL21Converter._convertContact(tradePartyType4)) != null) {
                partyType.setContact(contactType);
            }
            customerPartyType.setParty(partyType);
        }
        if ((tradePartyType3 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType3);
            for (TaxRegistrationType taxRegistrationType : tradePartyType3.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            ContactType contactType = CIIToUBL21Converter._convertContact(tradePartyType3);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            creditNoteType.setPayeeParty(partyType);
        }
        if ((tradePartyType2 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            PartyType partyType = CIIToUBL21Converter._convertParty(tradePartyType2);
            for (TaxRegistrationType taxRegistrationType : tradePartyType2.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme(taxRegistrationType);
                if (partyTaxSchemeType == null) continue;
                partyType.addPartyTaxScheme(partyTaxSchemeType);
            }
            ContactType contactType = CIIToUBL21Converter._convertContact(tradePartyType2);
            if (contactType != null) {
                partyType.setContact(contactType);
            }
            creditNoteType.setTaxRepresentativeParty(partyType);
        }
        if ((tradePartyType = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            TradeAddressType tradeAddressType;
            DateTimeType dateTimeType;
            DeliveryType deliveryType = new DeliveryType();
            SupplyChainEventType supplyChainEventType = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
            if (supplyChainEventType != null && (dateTimeType = supplyChainEventType.getOccurrenceDateTime()) != null) {
                deliveryType.setActualDeliveryDate(CIIToUBL21Converter._parseDate(dateTimeType.getDateTimeString(), (IErrorList)errorList));
            }
            LocationType locationType = new LocationType();
            boolean bl = false;
            oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType2 = CIIToUBL21Converter._extractPartyID(tradePartyType);
            if (iDType2 != null) {
                locationType.setID(iDType2);
                bl = true;
            }
            if ((tradeAddressType = tradePartyType.getPostalTradeAddress()) != null) {
                locationType.setAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType));
                bl = true;
            }
            if (bl) {
                deliveryType.setDeliveryLocation(locationType);
            }
            if ((iExplicitlyCloneable3 = tradePartyType.getName()) != null) {
                iExplicitlyCloneable2 = new PartyType();
                iExplicitlyCloneable = new PartyNameType();
                ((PartyNameType)iExplicitlyCloneable).setName(CIIToUBL21Converter._copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)iExplicitlyCloneable3, new NameType()));
                ((PartyType)iExplicitlyCloneable2).addPartyName((PartyNameType)iExplicitlyCloneable);
                deliveryType.setDeliveryParty((PartyType)iExplicitlyCloneable2);
            }
            creditNoteType.addDelivery(deliveryType);
        }
        for (TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, tradeSettlementPaymentMeansType, iDType -> CIIToUBL21Converter._addPartyID(iDType, creditNoteType.getAccountingSupplierParty().getParty()), creditNoteType::addPaymentMeans, errorList);
        }
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            boolean bl;
            boolean bl2 = false;
            PaymentTermsType paymentTermsType = new PaymentTermsType();
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType : tradePaymentTermsType.getDescription()) {
                paymentTermsType.addNote(CIIToUBL21Converter._copyNote(textType));
                bl = true;
            }
            if (!bl) continue;
            creditNoteType.addPaymentTerms(paymentTermsType);
        }
        for (TradeAllowanceChargeType tradeAllowanceChargeType : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            void var14_94;
            ETriState eTriState = ETriState.UNDEFINED;
            if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                ETriState eTriState2 = CIIToUBL21Converter._parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
            } else {
                errorList.add(CIIToUBL21Converter._buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!var14_94.isDefined()) continue;
            AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
            allowanceChargeType.setChargeIndicator(var14_94.getAsBooleanValue());
            this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object5);
            creditNoteType.addAllowanceCharge(allowanceChargeType);
        }
        TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        Object var13_61 = null;
        if (tradeSettlementHeaderMonetarySummationType != null && tradeSettlementHeaderMonetarySummationType.hasTaxTotalAmountEntries()) {
            for (un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType : tradeSettlementHeaderMonetarySummationType.getTaxTotalAmount()) {
                void var13_62;
                TaxTotalType taxTotalType = new TaxTotalType();
                taxTotalType.setTaxAmount(CIIToUBL21Converter._copyAmount(amountType, new TaxAmountType(), (String)object5));
                creditNoteType.addTaxTotal(taxTotalType);
                if (var13_62 != null) continue;
                TaxTotalType taxTotalType2 = taxTotalType;
            }
        } else {
            TaxAmountType taxAmountType = new TaxAmountType();
            taxAmountType.setValue(BigDecimal.ZERO);
            taxAmountType.setCurrencyID((String)object5);
            TaxTotalType taxTotalType = new TaxTotalType();
            taxTotalType.setTaxAmount(taxAmountType);
            creditNoteType.addTaxTotal(taxTotalType);
        }
        for (TradeTaxType tradeTaxType : headerTradeSettlementType.getApplicableTradeTax()) {
            void var13_65;
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            if (tradeTaxType.hasBasisAmountEntries()) {
                taxSubtotalType.setTaxableAmount(CIIToUBL21Converter._copyAmount(tradeTaxType.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object5));
            }
            if (tradeTaxType.hasCalculatedAmountEntries()) {
                taxSubtotalType.setTaxAmount(CIIToUBL21Converter._copyAmount(tradeTaxType.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object5));
            }
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType.getCategoryCodeValue());
            if (tradeTaxType.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(tradeTaxType.getRateApplicablePercentValue());
            }
            if (StringHelper.hasText(tradeTaxType.getExemptionReasonCodeValue())) {
                taxCategoryType.setTaxExemptionReasonCode(tradeTaxType.getExemptionReasonCodeValue());
            }
            if (tradeTaxType.getExemptionReason() != null) {
                TaxExemptionReasonType taxExemptionReasonType = new TaxExemptionReasonType();
                taxExemptionReasonType.setValue(tradeTaxType.getExemptionReason().getValue());
                taxExemptionReasonType.setLanguageID(tradeTaxType.getExemptionReason().getLanguageID());
                taxExemptionReasonType.setLanguageLocaleID(tradeTaxType.getExemptionReason().getLanguageLocaleID());
                taxCategoryType.addTaxExemptionReason(taxExemptionReasonType);
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            taxSubtotalType.setTaxCategory(taxCategoryType);
            var13_65.addTaxSubtotal(taxSubtotalType);
        }
        MonetaryTotalType monetaryTotalType = new MonetaryTotalType();
        if (tradeSettlementHeaderMonetarySummationType != null) {
            if (tradeSettlementHeaderMonetarySummationType.hasLineTotalAmountEntries()) {
                monetaryTotalType.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTaxBasisTotalAmountEntries()) {
                monetaryTotalType.setTaxExclusiveAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasGrandTotalAmountEntries()) {
                monetaryTotalType.setTaxInclusiveAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasAllowanceTotalAmountEntries()) {
                monetaryTotalType.setAllowanceTotalAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasChargeTotalAmountEntries()) {
                monetaryTotalType.setChargeTotalAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasTotalPrepaidAmountEntries()) {
                monetaryTotalType.setPrepaidAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasRoundingAmountEntries() && MathHelper.isNE0(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0).getValue())) {
                monetaryTotalType.setPayableRoundingAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object5));
            }
            if (tradeSettlementHeaderMonetarySummationType.hasDuePayableAmountEntries()) {
                monetaryTotalType.setPayableAmount(CIIToUBL21Converter._copyAmount(tradeSettlementHeaderMonetarySummationType.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object5));
            }
        }
        creditNoteType.setLegalMonetaryTotal(monetaryTotalType);
        for (SupplyChainTradeLineItemType supplyChainTradeLineItemType : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            boolean bl;
            Object object;
            IExplicitlyCloneable iExplicitlyCloneable4;
            Object object2;
            IExplicitlyCloneable iExplicitlyCloneable5;
            Object object3;
            Object object4;
            LineTradeSettlementType lineTradeSettlementType;
            QuantityType quantityType;
            CreditNoteLineType creditNoteLineType = new CreditNoteLineType();
            DocumentLineDocumentType documentLineDocumentType = supplyChainTradeLineItemType.getAssociatedDocumentLineDocument();
            creditNoteLineType.setID(CIIToUBL21Converter._copyID(documentLineDocumentType.getLineID()));
            for (NoteType noteType : documentLineDocumentType.getIncludedNote()) {
                creditNoteLineType.addNote(CIIToUBL21Converter._copyNote(noteType));
            }
            LineTradeDeliveryType lineTradeDeliveryType = supplyChainTradeLineItemType.getSpecifiedLineTradeDelivery();
            if (lineTradeDeliveryType != null && (quantityType = lineTradeDeliveryType.getBilledQuantity()) != null) {
                creditNoteLineType.setCreditedQuantity(CIIToUBL21Converter._copyQuantity(quantityType, new CreditedQuantityType()));
            }
            if ((iExplicitlyCloneable3 = (lineTradeSettlementType = supplyChainTradeLineItemType.getSpecifiedLineTradeSettlement()).getSpecifiedTradeSettlementLineMonetarySummation()) != null && ((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable3).hasLineTotalAmountEntries()) {
                creditNoteLineType.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(((TradeSettlementLineMonetarySummationType)iExplicitlyCloneable3).getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (lineTradeSettlementType.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                iExplicitlyCloneable2 = lineTradeSettlementType.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                creditNoteLineType.setAccountingCost(((TradeAccountingAccountType)iExplicitlyCloneable2).getIDValue());
            }
            if ((iExplicitlyCloneable2 = lineTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
                iExplicitlyCloneable = new PeriodType();
                if (((SpecifiedPeriodType)iExplicitlyCloneable2).getStartDateTime() != null) {
                    ((PeriodType)iExplicitlyCloneable).setStartDate(CIIToUBL21Converter._parseDate(((SpecifiedPeriodType)iExplicitlyCloneable2).getStartDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                if (((SpecifiedPeriodType)iExplicitlyCloneable2).getEndDateTime() != null) {
                    ((PeriodType)iExplicitlyCloneable).setEndDate(CIIToUBL21Converter._parseDate(((SpecifiedPeriodType)iExplicitlyCloneable2).getEndDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                creditNoteLineType.addInvoicePeriod((PeriodType)iExplicitlyCloneable);
            }
            if ((iExplicitlyCloneable = supplyChainTradeLineItemType.getSpecifiedLineTradeAgreement()) != null && (object4 = ((LineTradeAgreementType)iExplicitlyCloneable).getBuyerOrderReferencedDocument()) != null) {
                OrderLineReferenceType orderLineReferenceType = new OrderLineReferenceType();
                orderLineReferenceType.setLineID(CIIToUBL21Converter._copyID(((ReferencedDocumentType)object4).getLineID(), new LineIDType()));
                creditNoteLineType.addOrderLineReference(orderLineReferenceType);
            }
            for (ReferencedDocumentType referencedDocumentType5 : lineTradeSettlementType.getAdditionalReferencedDocument()) {
                object3 = CIIToUBL21Converter._convertDocumentReference(referencedDocumentType5, errorList);
                if (object3 == null) continue;
                creditNoteLineType.addDocumentReference((DocumentReferenceType)object3);
            }
            for (TradeAllowanceChargeType tradeAllowanceChargeType : lineTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
                object3 = ETriState.UNDEFINED;
                if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                    object3 = CIIToUBL21Converter._parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), errorList);
                } else {
                    errorList.add(CIIToUBL21Converter._buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!((ETriState)object3).isDefined()) continue;
                AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                allowanceChargeType.setChargeIndicator(((ETriState)object3).getAsBooleanValue());
                this._copyAllowanceCharge(tradeAllowanceChargeType, allowanceChargeType, (String)object5);
                creditNoteLineType.addAllowanceCharge(allowanceChargeType);
            }
            object4 = new ItemType();
            TradeProductType tradeProductType = supplyChainTradeLineItemType.getSpecifiedTradeProduct();
            if (tradeProductType != null) {
                IDType iDType3;
                object3 = tradeProductType.getDescription();
                if (object3 != null) {
                    ((ItemType)object4).addDescription(CIIToUBL21Converter._copyName((un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType)object3, new DescriptionType()));
                }
                if (tradeProductType.hasNameEntries()) {
                    ((ItemType)object4).setName(CIIToUBL21Converter._copyName(tradeProductType.getNameAtIndex(0), new NameType()));
                }
                if ((iDType3 = tradeProductType.getBuyerAssignedID()) != null) {
                    iExplicitlyCloneable5 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable5).setID(CIIToUBL21Converter._copyID(iDType3));
                    ((ItemType)object4).setBuyersItemIdentification((ItemIdentificationType)iExplicitlyCloneable5);
                }
                if ((iExplicitlyCloneable5 = tradeProductType.getSellerAssignedID()) != null) {
                    object2 = new ItemIdentificationType();
                    ((ItemIdentificationType)object2).setID(CIIToUBL21Converter._copyID((IDType)iExplicitlyCloneable5));
                    ((ItemType)object4).setSellersItemIdentification((ItemIdentificationType)object2);
                }
                if ((object2 = tradeProductType.getGlobalID()) != null) {
                    iExplicitlyCloneable4 = new ItemIdentificationType();
                    ((ItemIdentificationType)iExplicitlyCloneable4).setID(CIIToUBL21Converter._copyID((IDType)object2));
                    ((ItemType)object4).setStandardItemIdentification((ItemIdentificationType)iExplicitlyCloneable4);
                }
                if ((iExplicitlyCloneable4 = tradeProductType.getOriginTradeCountry()) != null) {
                    object = new CountryType();
                    ((CountryType)object).setIdentificationCode(((TradeCountryType)iExplicitlyCloneable4).getIDValue());
                    if (((TradeCountryType)iExplicitlyCloneable4).hasNameEntries()) {
                        ((CountryType)object).setName(CIIToUBL21Converter._copyName(((TradeCountryType)iExplicitlyCloneable4).getNameAtIndex(0), new NameType()));
                    }
                    ((ItemType)object4).setOriginCountry((CountryType)object);
                }
                for (ProductClassificationType productClassificationType : tradeProductType.getDesignatedProductClassification()) {
                    CodeType codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL21Converter._copyCode(codeType, new ItemClassificationCodeType()));
                    ((ItemType)object4).addCommodityClassification(commodityClassificationType);
                }
            }
            for (TradeTaxType tradeTaxType : lineTradeSettlementType.getApplicableTradeTax()) {
                iExplicitlyCloneable5 = new TaxCategoryType();
                ((TaxCategoryType)iExplicitlyCloneable5).setID(tradeTaxType.getCategoryCodeValue());
                if (tradeTaxType.getRateApplicablePercentValue() != null) {
                    ((TaxCategoryType)iExplicitlyCloneable5).setPercent(tradeTaxType.getRateApplicablePercentValue());
                }
                object2 = new TaxSchemeType();
                ((TaxSchemeType)object2).setID(this.getVATScheme());
                ((TaxCategoryType)iExplicitlyCloneable5).setTaxScheme((TaxSchemeType)object2);
                ((ItemType)object4).addClassifiedTaxCategory((TaxCategoryType)iExplicitlyCloneable5);
            }
            if (tradeProductType != null) {
                for (ProductCharacteristicType productCharacteristicType : tradeProductType.getApplicableProductCharacteristic()) {
                    if (!productCharacteristicType.hasDescriptionEntries()) continue;
                    iExplicitlyCloneable5 = new ItemPropertyType();
                    ((ItemPropertyType)iExplicitlyCloneable5).setName(CIIToUBL21Converter._copyName(productCharacteristicType.getDescriptionAtIndex(0), new NameType()));
                    if (productCharacteristicType.hasValueEntries()) {
                        ((ItemPropertyType)iExplicitlyCloneable5).setValue(productCharacteristicType.getValueAtIndex(0).getValue());
                    }
                    ((ItemType)object4).addAdditionalItemProperty((ItemPropertyType)iExplicitlyCloneable5);
                }
            }
            object3 = new PriceType();
            boolean bl3 = false;
            if (iExplicitlyCloneable != null && (iExplicitlyCloneable5 = ((LineTradeAgreementType)iExplicitlyCloneable).getNetPriceProductTradePrice()) != null) {
                if (((TradePriceType)iExplicitlyCloneable5).hasChargeAmountEntries()) {
                    ((PriceType)object3).setPriceAmount(CIIToUBL21Converter._copyAmount(((TradePriceType)iExplicitlyCloneable5).getChargeAmountAtIndex(0), new PriceAmountType(), (String)object5));
                    boolean bl4 = true;
                }
                if (((TradePriceType)iExplicitlyCloneable5).getBasisQuantity() != null) {
                    ((PriceType)object3).setBaseQuantity(CIIToUBL21Converter._copyQuantity(((TradePriceType)iExplicitlyCloneable5).getBasisQuantity(), new BaseQuantityType()));
                    bl = true;
                }
            }
            if ((iExplicitlyCloneable5 = ((LineTradeAgreementType)iExplicitlyCloneable).getNetPriceProductTradePrice()) != null) {
                object2 = ((TradePriceType)iExplicitlyCloneable5).getAppliedTradeAllowanceCharge().iterator();
                while (object2.hasNext()) {
                    iExplicitlyCloneable4 = (TradeAllowanceChargeType)object2.next();
                    object = ETriState.UNDEFINED;
                    if (((TradeAllowanceChargeType)iExplicitlyCloneable4).getChargeIndicator() != null) {
                        object = CIIToUBL21Converter._parseIndicator(((TradeAllowanceChargeType)iExplicitlyCloneable4).getChargeIndicator(), errorList);
                    } else {
                        errorList.add(CIIToUBL21Converter._buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeAgreement", "NetPriceProductTradePrice", "AppliedTradeAllowanceCharge"}, "Failed to determine if AppliedTradeAllowanceCharge is an Allowance or a Charge"));
                    }
                    if (!((ETriState)object).isDefined()) continue;
                    AllowanceChargeType allowanceChargeType = new AllowanceChargeType();
                    allowanceChargeType.setChargeIndicator(((ETriState)object).getAsBooleanValue());
                    this._copyAllowanceCharge((TradeAllowanceChargeType)iExplicitlyCloneable4, allowanceChargeType, (String)object5);
                    ((PriceType)object3).addAllowanceCharge(allowanceChargeType);
                }
            }
            if (bl) {
                creditNoteLineType.setPrice((PriceType)object3);
            }
            creditNoteLineType.setItem((ItemType)object4);
            creditNoteType.addCreditNoteLine(creditNoteLineType);
        }
        return creditNoteType;
    }

    @Override
    @Nullable
    public Serializable convertCIItoUBL(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull(crossIndustryInvoiceType, "CIIInvoice");
        ValueEnforcer.notNull(errorList, "ErrorList");
        switch (this.getUBLCreationMode()) {
            case AUTOMATIC: {
                SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
                HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType == null ? null : supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
                TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType == null ? null : headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
                un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType = tradeSettlementHeaderMonetarySummationType == null || tradeSettlementHeaderMonetarySummationType.hasNoDuePayableAmountEntries() ? null : tradeSettlementHeaderMonetarySummationType.getDuePayableAmount().get(0);
                boolean bl = amountType == null || MathHelper.isGE0(amountType.getValue());
                return bl ? this.convertToInvoice(crossIndustryInvoiceType, errorList) : this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
            case INVOICE: {
                return this.convertToInvoice(crossIndustryInvoiceType, errorList);
            }
            case CREDIT_NOTE: {
                return this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
        }
        throw new IllegalStateException("Unsupported creation mode");
    }
}

