/*
 * Decompiled with CFR 0.152.
 */
package com.helger.en16931.cii2ubl;

import com.helger.cii.d16b.CIID16BReader;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFromString;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.en16931.cii2ubl.EUBLCreationMode;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.xsds.ccts.cct.schemamodule.AmountType;
import com.helger.xsds.ccts.cct.schemamodule.CodeType;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import un.unece.uncefact.data.standard.crossindustryinvoice._100.CrossIndustryInvoiceType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;

public abstract class AbstractCIIToUBLConverter<IMPLTYPE extends AbstractCIIToUBLConverter<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    public static final EUBLCreationMode DEFAULT_UBL_CREATION_MODE = EUBLCreationMode.AUTOMATIC;
    public static final String DEFAULT_VAT_SCHEME = "VAT";
    public static final String DEFAULT_CUSTOMIZATION_ID = "urn:cen.eu:en16931:2017:extended:urn:fdc:peppol.eu:2017:poacc:billing:3.0";
    public static final String DEFAULT_PROFILE_ID = "urn:fdc:peppol.eu:2017:poacc:billing:01:1.0";
    public static final String DEFAULT_CARD_ACCOUNT_NETWORK_ID = "mapped-from-cii";
    private EUBLCreationMode m_eCreationMode = DEFAULT_UBL_CREATION_MODE;
    private String m_sVATScheme = "VAT";
    private String m_sCustomizationID = "urn:cen.eu:en16931:2017:extended:urn:fdc:peppol.eu:2017:poacc:billing:3.0";
    private String m_sProfileID = "urn:fdc:peppol.eu:2017:poacc:billing:01:1.0";
    private String m_sCardAccountNetworkID = "mapped-from-cii";

    protected AbstractCIIToUBLConverter() {
    }

    @Nonnull
    public final EUBLCreationMode getUBLCreationMode() {
        return this.m_eCreationMode;
    }

    @Nonnull
    public final IMPLTYPE setUBLCreationMode(@Nonnull EUBLCreationMode eUBLCreationMode) {
        ValueEnforcer.notNull(eUBLCreationMode, "CreationMode");
        this.m_eCreationMode = eUBLCreationMode;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getVATScheme() {
        return this.m_sVATScheme;
    }

    @Nonnull
    public final IMPLTYPE setVATScheme(@Nonnull String string) {
        ValueEnforcer.notNull(string, "VATScheme");
        this.m_sVATScheme = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getCustomizationID() {
        return this.m_sCustomizationID;
    }

    @Nonnull
    public final IMPLTYPE setCustomizationID(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CustomizationID");
        this.m_sCustomizationID = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getProfileID() {
        return this.m_sProfileID;
    }

    @Nonnull
    public final IMPLTYPE setProfileID(@Nonnull String string) {
        ValueEnforcer.notNull(string, "ProfileID");
        this.m_sProfileID = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    public final String getCardAccountNetworkID() {
        return this.m_sCardAccountNetworkID;
    }

    @Nonnull
    public final IMPLTYPE setCardAccountNetworkID(@Nonnull String string) {
        ValueEnforcer.notNull(string, "CardAccountNetworkID");
        this.m_sCardAccountNetworkID = string;
        return (IMPLTYPE)((AbstractCIIToUBLConverter)this.thisAsT());
    }

    @Nonnull
    protected static IError _buildError(@Nullable String[] stringArray, String string) {
        return ((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorText(string)).setErrorFieldName(stringArray == null ? null : StringHelper.getImploded('/', stringArray))).build();
    }

    @Nullable
    public static String _getDatePattern(@Nonnull @Nonempty String string, @Nonnull IErrorList iErrorList) {
        ValueEnforcer.notEmpty(string, "Format");
        ValueEnforcer.notNull(iErrorList, "ErrorList");
        switch (string) {
            case "2": {
                return "ddMMuu";
            }
            case "3": {
                return "MMdduu";
            }
            case "4": {
                return "ddMMuuuu";
            }
            case "101": {
                return "uuMMdd";
            }
            case "102": {
                return "uuuuMMdd";
            }
            case "103": {
                return "YYwwee";
            }
            case "105": {
                return "uuDDD";
            }
        }
        iErrorList.add(AbstractCIIToUBLConverter._buildError(null, "Unsupported date format '" + string + "'"));
        return null;
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable String string, @Nullable String string2, @Nonnull IErrorList iErrorList) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string3 = StringHelper.getNotEmpty(string2, "102");
        String string4 = AbstractCIIToUBLConverter._getDatePattern(string3, iErrorList);
        if (string4 == null) {
            return null;
        }
        LocalDate localDate = PDTFromString.getLocalDateFromString(string, string4);
        if (localDate == null) {
            iErrorList.add(AbstractCIIToUBLConverter._buildError(null, "Failed to parse the date '" + string + "' using format '" + string3 + "'"));
        }
        return localDate;
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable DateTimeType.DateTimeString dateTimeString, @Nonnull IErrorList iErrorList) {
        if (dateTimeString == null) {
            return null;
        }
        return AbstractCIIToUBLConverter._parseDate(dateTimeString.getValue(), dateTimeString.getFormat(), iErrorList);
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable FormattedDateTimeType.DateTimeString dateTimeString, @Nonnull IErrorList iErrorList) {
        if (dateTimeString == null) {
            return null;
        }
        return AbstractCIIToUBLConverter._parseDate(dateTimeString.getValue(), dateTimeString.getFormat(), iErrorList);
    }

    @Nullable
    protected static LocalDate _parseDate(@Nullable DateType.DateString dateString, @Nonnull IErrorList iErrorList) {
        if (dateString == null) {
            return null;
        }
        return AbstractCIIToUBLConverter._parseDate(dateString.getValue(), dateString.getFormat(), iErrorList);
    }

    @Nonnull
    protected static ETriState _parseIndicator(@Nullable IndicatorType indicatorType, @Nonnull IErrorList iErrorList) {
        if (indicatorType == null) {
            return ETriState.UNDEFINED;
        }
        if (indicatorType.isIndicator() != null) {
            return ETriState.valueOf((boolean)indicatorType.isIndicator());
        }
        if (indicatorType.getIndicatorString() != null) {
            String string = indicatorType.getIndicatorStringValue();
            if (string == null) {
                return ETriState.UNDEFINED;
            }
            if ("true".equals(string)) {
                return ETriState.TRUE;
            }
            if ("false".equals(string)) {
                return ETriState.FALSE;
            }
            iErrorList.add(AbstractCIIToUBLConverter._buildError(null, "Failed to parse the indicator value '" + indicatorType + "' to a boolean value."));
            return ETriState.UNDEFINED;
        }
        throw new IllegalStateException("Indicator has neither string nor boolen");
    }

    @Nullable
    protected static <T extends IdentifierType> T _copyID(@Nullable IDType iDType, @Nonnull T t) {
        if (iDType == null) {
            return null;
        }
        if (StringHelper.hasNoText(iDType.getValue())) {
            return null;
        }
        t.setValue(iDType.getValue());
        t.setSchemeID(iDType.getSchemeID());
        t.setSchemeName(iDType.getSchemeName());
        t.setSchemeAgencyID(iDType.getSchemeAgencyID());
        t.setSchemeAgencyName(iDType.getSchemeAgencyName());
        t.setSchemeVersionID(iDType.getSchemeVersionID());
        t.setSchemeDataURI(iDType.getSchemeDataURI());
        t.setSchemeURI(iDType.getSchemeURI());
        return t;
    }

    @Nullable
    protected static <T extends TextType> T _copyName(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType textType, @Nonnull T t) {
        if (textType == null) {
            return null;
        }
        t.setValue(textType.getValue());
        t.setLanguageID(textType.getLanguageID());
        t.setLanguageLocaleID(textType.getLanguageLocaleID());
        return t;
    }

    @Nullable
    protected static <T extends CodeType> T _copyCode(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType codeType, @Nonnull T t) {
        if (codeType == null) {
            return null;
        }
        t.setValue(codeType.getValue());
        t.setListID(codeType.getListID());
        t.setListAgencyID(codeType.getListAgencyID());
        t.setListAgencyName(codeType.getListAgencyName());
        t.setListName(codeType.getListName());
        t.setListVersionID(codeType.getListVersionID());
        t.setName(codeType.getName());
        t.setLanguageID(codeType.getLanguageID());
        t.setListURI(codeType.getListURI());
        t.setListSchemeURI(codeType.getListSchemeURI());
        return t;
    }

    @Nullable
    protected static <T extends com.helger.xsds.ccts.cct.schemamodule.QuantityType> T _copyQuantity(@Nullable QuantityType quantityType, @Nonnull T t) {
        if (quantityType == null) {
            return null;
        }
        t.setValue(quantityType.getValue());
        t.setUnitCode(quantityType.getUnitCode());
        t.setUnitCodeListID(quantityType.getUnitCodeListID());
        t.setUnitCodeListAgencyID(quantityType.getUnitCodeListAgencyID());
        t.setUnitCodeListAgencyName(quantityType.getUnitCodeListAgencyName());
        return t;
    }

    @Nullable
    protected static <T extends AmountType> T _copyAmount(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType, @Nonnull T t, @Nullable String string) {
        if (amountType == null) {
            return null;
        }
        t.setValue(amountType.getValue());
        t.setCurrencyID(amountType.getCurrencyID());
        if (StringHelper.hasNoText(t.getCurrencyID())) {
            t.setCurrencyID(string);
        }
        t.setCurrencyCodeListVersionID(amountType.getCurrencyCodeListVersionID());
        return t;
    }

    protected static boolean isPaymentMeansCodeCreditTransfer(@Nullable String string) {
        return "30".equals(string) || "58".equals(string);
    }

    protected static boolean isPaymentMeansCodePaymentCard(@Nullable String string) {
        return "48".equals(string);
    }

    protected static boolean isPaymentMeansCodeDirectDebit(@Nullable String string) {
        return "49".equals(string) || "59".equals(string);
    }

    protected static boolean isPaymentMeansCodeOtherKnown(@Nullable String string) {
        return "57".equals(string);
    }

    protected static boolean isOriginatorDocumentReferenceTypeCode(@Nullable String string) {
        return "50".equals(string);
    }

    @Nullable
    public Serializable convertCIItoUBL(@Nonnull File file, @Nonnull ErrorList errorList) {
        CrossIndustryInvoiceType crossIndustryInvoiceType = (CrossIndustryInvoiceType)((CIID16BReader)CIID16BReader.crossIndustryInvoice().setValidationEventHandler(new WrappedCollectingValidationEventHandler(errorList))).read(file);
        if (crossIndustryInvoiceType == null) {
            return null;
        }
        return this.convertCIItoUBL(crossIndustryInvoiceType, errorList);
    }

    @Nullable
    public abstract Serializable convertCIItoUBL(@Nonnull CrossIndustryInvoiceType var1, @Nonnull ErrorList var2);
}

