/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.level.IHasErrorLevel;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class LogHelper {
    private static final LogHelper s_aInstance = new LogHelper();

    private LogHelper() {
    }

    @Nonnull
    public static IFuncIsLoggingEnabled getFuncIsEnabled(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        if (iErrorLevel.isGE(EErrorLevel.ERROR)) {
            return logger::isErrorEnabled;
        }
        if (iErrorLevel.isGE(EErrorLevel.WARN)) {
            return logger::isWarnEnabled;
        }
        if (iErrorLevel.isGE(EErrorLevel.INFO)) {
            return logger::isInfoEnabled;
        }
        return logger::isDebugEnabled;
    }

    @Nonnull
    public static IFuncLogger getFuncLogger(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        if (iErrorLevel.isGE(EErrorLevel.ERROR)) {
            return logger::error;
        }
        if (iErrorLevel.isGE(EErrorLevel.WARN)) {
            return logger::warn;
        }
        if (iErrorLevel.isGE(EErrorLevel.INFO)) {
            return logger::info;
        }
        return logger::debug;
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogHelper.isEnabled(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogHelper.isEnabled(logger, iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel) {
        return LogHelper.isEnabled(LoggerFactory.getLogger(clazz), iErrorLevel);
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel) {
        return LogHelper.getFuncIsEnabled(logger, iErrorLevel).isEnabled();
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogHelper.log(clazz, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        LogHelper.log(clazz, iErrorLevel, string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iErrorLevel, string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        LogHelper.log(logger, iErrorLevel, string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        ValueEnforcer.notNull(string, "Message");
        if (LogHelper.isEnabled(logger, iErrorLevel)) {
            LogHelper.getFuncLogger(logger, iErrorLevel).log(string, throwable);
        }
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull Supplier<String> supplier) {
        LogHelper.log(clazz, iHasErrorLevel.getErrorLevel(), supplier, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull Supplier<String> supplier, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), supplier, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull Supplier<String> supplier) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), supplier, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull Supplier<String> supplier, @Nullable Throwable throwable) {
        LogHelper.log(logger, iHasErrorLevel.getErrorLevel(), supplier, throwable);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull Supplier<String> supplier) {
        LogHelper.log(clazz, iErrorLevel, supplier, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull Supplier<String> supplier, @Nullable Throwable throwable) {
        LogHelper.log(LoggerFactory.getLogger(clazz), iErrorLevel, supplier, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull Supplier<String> supplier) {
        LogHelper.log(logger, iErrorLevel, supplier, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull Supplier<String> supplier, @Nullable Throwable throwable) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        ValueEnforcer.notNull(supplier, "MessageSupplier");
        if (LogHelper.isEnabled(logger, iErrorLevel)) {
            LogHelper.getFuncLogger(logger, iErrorLevel).log(supplier.get(), throwable);
        }
    }

    @FunctionalInterface
    public static interface IFuncLogger {
        public void log(@Nonnull String var1, @Nullable Throwable var2);
    }

    @FunctionalInterface
    public static interface IFuncIsLoggingEnabled {
        public boolean isEnabled();
    }
}

