/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.safe;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SafeArrayList<ELEMENTTYPE>
extends CommonsArrayList<ELEMENTTYPE> {
    @MustImplementEqualsAndHashcode
    private final ISupplier<? extends ELEMENTTYPE> m_aFactory;

    public SafeArrayList() {
        this(() -> null);
    }

    public SafeArrayList(@Nonnull ISupplier<? extends ELEMENTTYPE> iSupplier) {
        this.m_aFactory = ValueEnforcer.notNull(iSupplier, "Factory");
    }

    @Nonnull
    public ISupplier<? extends ELEMENTTYPE> getFactory() {
        return this.m_aFactory;
    }

    private void _ensureSize(@Nonnegative int n) {
        int n2 = n - this.size() + 1;
        for (int i = 0; i < n2; ++i) {
            this.add(this.m_aFactory.get());
        }
    }

    @Override
    public ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    @Nullable
    public ELEMENTTYPE computeIfAbsent(@Nonnegative int n, @Nonnull Supplier<? extends ELEMENTTYPE> supplier) {
        this._ensureSize(n);
        Object object = super.get(n);
        if (object == null) {
            object = supplier.get();
            super.set(n, object);
        }
        return (ELEMENTTYPE)object;
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int n, @Nonnull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeArrayList safeArrayList = (SafeArrayList)object;
        return this.m_aFactory.equals(safeArrayList.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).getToString();
    }
}

