/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorShort {
    private final short[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorShort(short ... sArray) {
        this(sArray, 0, sArray.length);
    }

    public ArrayIteratorShort(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(sArray, n, n2);
        this.m_aArray = ArrayHelper.getCopy(sArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public short next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorShort arrayIteratorShort = (ArrayIteratorShort)object;
        return EqualsHelper.equals(this.m_aArray, arrayIteratorShort.m_aArray) && this.m_nIndex == arrayIteratorShort.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }
}

